<?php

namespace App\Controller;

use App\Entity\Service;
use App\AbstractController;
use App\Entity\PV;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class PvController extends AbstractController
{
    /**
     * @Route("/pv", name="pv_new")
     */
    public function index(Request $request): Response
    {
        $entityManager = $this->getDoctrine()->getManager();
        $serviceRepository = $entityManager->getRepository(Service::class);
        $pvRepository = $entityManager->getRepository(PV::class);
        $services = $serviceRepository->findBy(['type' => 2], ['name' => 'ASC']);
        $violationList = [];

        if ($request->isMethod('POST')) {
            $serviceId = \intval($request->request->get('service'));
            $pv = new PV();
            $pv->setService($serviceRepository->find($serviceId));
            $violationList = $this->validator->validate($pv);
            $this->get('session')->getFlashBag()->clear();

            if (\count($violationList) > 0) {
                $message = 'Le formulaire contient des erreurs';
                $flashType = 'danger';
            } else {
                $entityManager->persist($pv);
                $entityManager->flush();
                $message = 'PV ajouté avec succès';
                $flashType = 'success';
            }

            $this->addFlash($flashType, $message);
        }

        $addalread = $pvRepository->findAll();
        // $totalValue = \array_reduce($addalread, fn ($accu, $next) => $accu + $next->getService()->getUnitPrice(), 0);

        return $this->render('pv/index.html.twig', [
            'title' => 'Articles PV de Controle technique',
            'breadcrumb' => [
                ['name' => 'Articles PV de Controle technique']
            ],
            'servicesSent' => $services,
            'AddedAlready'=> $addalread,
            'violations' => $violationList,
            // 'totalValue' => $totalValue
        ]);
    }

    /**
     * @Route("/pv/{id}",name="delete_pv")
     */
    public function deletepv(Request $request, $id){

        $manager = $this->getDoctrine()->getManager();
        $pvEnt= $manager->getRepository(PV::class)->find(\intval($id));
        $manager->remove($pvEnt);
        $manager->flush();

        return $this->redirectToRoute('pv_new');
    }

    /**
     * @Route("/procesverbal/getvalues",name="")
     */
    public function getpvprice():JsonResponse {

        $manager = $this->getDoctrine()->getManager();
        $service= $manager->getRepository(Service::class);
        $pvEnt= $manager->getRepository(PV::class);

        $sql=$this->db->getPdo()->query("SELECT SUM(S.unit_price) somme FROM pv P INNER JOIN service S ON S.id=P.service_id ");
        $data=$sql->fetch(); $total=$data['somme'];

        return new JsonResponse(['sommesent'=> $total]);
    }
}
