<?php

namespace App\Controller;

use App\Entity\ObservationControleTechnique;
use App\Http\ApiResponse;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;

class ObservationControleTechniqueController extends AbstractController
{
    private $slugger;

    public function __construct(SluggerInterface $slugger)
    {
        $this->slugger = $slugger;
    }

    /**
     * @Route("/observations-controle-technique", name="observations_controle_technique")
     */
    public function index(): ApiResponse
    {
        $entityManager = $this->getDoctrine()->getManager();
        $observations = $entityManager
            ->createQuery("SELECT o.id, o.slug, o.name FROM App\Entity\ObservationControleTechnique o")
            ->getResult()
        ;

        return new ApiResponse('', $observations);
    }

    /**
     * @Route("/create-observation-controle-technique", name="create_observation_controle_technique")
     */
    public function create(): ApiResponse
    {
        return $this->edit();
    }

    /**
     * @Route("/update-observation-controle-technique/{id}", name="update_observation_controle_technique")
     */
    public function update($id): ApiResponse
    {
        return $this->edit($id);
    }

    private function edit(?int $id = null): ApiResponse
    {
        $entityManager = $this->getDoctrine()->getManager();
        $data = json_decode(file_get_contents('php://input'), true);

        $observation = $id === null
            ? new ObservationControleTechnique()
            : $entityManager->getRepository(ObservationControleTechnique::class)->find($id)
        ;

        $name = trim($data['name']);
        $slug = $this->slugger->slug($name, '-', 'en');
        $observation->setSlug($slug);
        $observation->setName($name);

        if (is_null($id)) {
            $entityManager->persist($observation);
        }

        $entityManager->flush();

        return new ApiResponse('Observation enregistrée avec succès', [
            'id' => (is_null($id) ? $observation->getId() : $id),
            'slug' => $slug,
            'name' => $name
        ]);
    }
}
