// import $ from 'jquery';
// import Sidenav from './mdb/src/js/pro/sidenav';

// const sidenav = document.getElementById("sidenav-1");
// const instance = mdb.Sidenav.getInstance(sidenav);

// let innerWidth = null;

// const setMode = (e) => {
//   // Check necessary for Android devices
//   if (window.innerWidth === innerWidth) {
//     return;
//   }

//   innerWidth = window.innerWidth;

//   if (window.innerWidth < 1400) {
//     instance.changeMode("over");
//     instance.hide();
//   } else {
//     instance.changeMode("side");
//     instance.show();
//   }
// };

//       setMode();

//       // Event listeners
// window.addEventListener("resize", setMode);

const roles = localStorage.getItem('roles').split(',');
const user = document.querySelector('main').dataset.user;
let topics = [];
const notifications = [];
let menuShown = false;
const baseUrl = localStorage.getItem('baseUrl');
const notificationsDropdown = document.querySelector('#navbarDropdownMenuLinkNotif + div');
const badgeElt = document.querySelector('#navbarDropdownMenuLinkNotif > .badge');
const notificationsDropdownMenu = document.querySelector('#notifications-list');

function showNotifications(data) {
  let listItems = '';
  menuShown = true;
  // console.log(data);
  data.forEach(item => {
    listItems += `
      <li class="px-3 py-2 notification border-bottom">
        <div class="d-flex justify-content-between">
          <div class="font-weight-bold">${item.date}</div>
          <div class="text-white rounded px-2 py-0 bg-${item.alert ?? 'info'} small">${item.topic?.substr(0, 40)}${item.topic.indexOf('stock_level') !== 1 && roles.indexOf('ROLE_GESTSTOCK') !== -1 ? ' --> ' + item.depotName : ''}</div>
        </div>
    `;

    if (typeof item.product !== 'undefined' && typeof item.quantity !== 'undefined') {
      listItems += `
        <div class="d-flex justify-content-start align-items-center ml-1">
          <div>${item.product}</div>
          <div class="badge text-dark p-1 border border-${item.alert} ml-3 mr-0">${item.grantedQuantity ?? item.quantity}</div>
        </div>
      `;
    } else {
      listItems += `<div>${item.message}</div>`;
    }

    listItems += '</li>';
  });
  notificationsDropdown.classList.add('border');
  notificationsDropdownMenu.innerHTML = listItems;
  notificationsDropdown.style.display = 'block';
  badgeElt.setAttribute('hidden', 'hidden');
}

function hideNotifications() {
  menuShown = false;
  notificationsDropdown.classList.remove('border');
  notificationsDropdownMenu.innerHTML = '';
  notificationsDropdown.style.display = 'none';
  badgeElt.removeAttribute('hidden');
}

function toggleNotifications(data) {
  notifications.length > 0 && !menuShown ? showNotifications(data) : hideNotifications();
}

function subscribeToSSE(topics) {
  if (topics.length > 0) {
    const url = new URL(baseUrl + '/.well-known/mercure');
    console.log(url);

    topics.forEach(topic => {
      url.searchParams.append('topic', topic);
    });

    const eventSource = new EventSource(url);

    // The callback will be called every time an update is published
    eventSource.onmessage = (e) => {
      const notification = JSON.parse(e.data);
      const notificationsNumber = Number.parseInt(badgeElt.dataset.notificationsNumber, 10);
      // console.log(notification);

      Object.assign(notification, { date: new Date().toLocaleDateString('fr-FR', { year: 'numeric', month: 'short', day: 'numeric', hour: 'numeric', minute: 'numeric' }) });

      if (notifications.length > 0) {
        notifications.unshift(notification);
      } else {
        notifications.push(notification);
      }

      if (notificationsNumber === 0) {
        badgeElt.removeAttribute('hidden');
      }

      badgeElt.dataset.notificationsNumber = notificationsNumber + 1;
      badgeElt.textContent = badgeElt.dataset.notificationsNumber;

      if (window.location.pathname === '/fichestock') {
        const currentRow = stocks.find(row => row.id === notification.depotDetailId);
        if (typeof currentRow !== 'undefined') {
          Object.assign(currentRow, { quantity: notification.quantity });
          stocksTableInstance.update({ rows: setStocks(stocks) });
        }
      } else if (window.location.pathname === '/depots/demandeapprovisionnement') {
        if (roles.indexOf('ROLE_GESTSTOCK') !== -1) {
          procurementRequests = procurementRequests.filter(pr => pr.id !== notification.id);
          procurementRequests.unshift(notification);
          procurementsTableInstance.update({ rows: getRows(procurementRequests) }, { loading: false, hover: true });
        } else {
          const procurementItem = `
            <div class="list-group-item list-group-item-action d-flex justify-content-between align-items-center" href="#">
              <div>${notification['serviceName']} (${notification['grantedQuantity']}${notification['uomSymbol'] ?? ''})</div>
              <div class="action-buttons" data-procurement-id="${notification['id']}" data-procurement-quantity="${notification['quantity']}">
                <button type="button" class="btn btn-sm btn-rounded btn-success" data-key="0" onclick="actOnProcurementRequest(event)">
                  <i class="fas fa-check"></i>
                </button>
                <button type="button" class="btn btn-sm btn-rounded btn-danger" data-key="1" onclick="actOnProcurementRequest(event)">
                  <i class="fas fa-times"></i>
                </button>
              </div>
            </div>
          `;

          document.querySelector('#procurements-list').innerHTML += procurementItem;
        }
      }
    };

    document.querySelector('#navbarDropdownMenuLinkNotif').addEventListener('click', () => {
      toggleNotifications(notifications);
    });
  }
}

if (roles.indexOf('ROLE_GESTSTOCK') !== -1) {
  const posUrl = new URL('api/point_of_sales.json', baseUrl);
  const depotUrl = new URL('api/depots.json', baseUrl);

  fetch(depotUrl, {
    method: 'GET',
    headers: new Headers({ 'Authorization': 'Bearer ' + localStorage.getItem('token') })
  }).then((response) => {
    if (response.ok) {
      response.text().then((resp) => {
        const depots = JSON.parse(resp);

        depots.forEach((depot) => {
          const depotTopic = 'stock_level_depot_' + depot.id;
          if (topics.indexOf(depotTopic) === -1) {
            topics.push(depotTopic);
          }
        });

        fetch(posUrl, {
          method: 'GET',
          headers: new Headers({ 'Authorization': 'Bearer ' + localStorage.getItem('token') })
        }).then((response) => {
          if (response.ok) {
            response.text().then((resp) => {
              const pointsOfSale = JSON.parse(resp);
              pointsOfSale.forEach((pos) => {
                const posTopic = 'stock_level_pos_' + pos.id;
                if (topics.indexOf(posTopic) === -1) {
                  topics.push(posTopic);
                }
              });
            // 	subscribeToSSE(topics);
            });
          } else if (response.status === 401) {
            window.location.assign(`${localStorage.getItem('baseUrl')}/logout`);
          }
        });
      });
    } else if (response.status === 401) {
      window.location.assign(`${localStorage.getItem('baseUrl')}/logout`);
    }
  });
} else if (roles.indexOf('ROLE_GESTOCKPOS') !== -1) {
  const request = new Request(`${localStorage.getItem('baseUrl')}/api/users/${localStorage.getItem('userId')}/affectation/pos.json`);
  request.headers.set('Authorization', 'Bearer ' + localStorage.getItem('token'));

  fetch(request).then((response) => {
    if (response.ok) {
      response.text().then((resp) => {
        const pos = JSON.parse(resp);
        if (topics.indexOf('stock_level_pos_' + pos.id) === -1) {
          topics.push('stock_level_pos_' + pos.id);
        }
    // 		subscribeToSSE(topics);
      });
    } else if (response.status === 401) {
      window.location.assign(`${localStorage.getItem('baseUrl')}/logout`);
    }
  });
}

document.addEventListener('keydown', (e) => {
  if (e.key === 'Control') {
    const slashHandler = (event) => {
      if (event.key === '/') {
        document.querySelector('#global-search').focus();
      }
      document.removeEventListener('keyup', slashHandler);
    };
    document.addEventListener('keyup', slashHandler);
  }
});

(() => {
  'use strict';
  // Fetch all the forms we want to apply custom Bootstrap validation styles to
  const forms = document.querySelectorAll('form');
  // Loop over them and prevent submission
  Array.prototype.slice.call(forms).forEach(form => {
    form.addEventListener('submit', event => {
      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      }
      form.classList.add('was-validated');
    }, false);
  });
})();
