const invoicesDatatable = document.getElementById('invoices-datatable');
const invoices = JSON.parse(invoicesDatatable.dataset.invoices);
const currency = invoicesDatatable.dataset.currency;
const spinner = document.querySelector('#spinner');

window.setActions = function() {
    // console.log(document.getElementsByClassName('cancel-invoice'))
    document.querySelectorAll('.cancel-invoice').forEach(btn => {
        btn.addEventListener('click', () => {
            if (confirm('Voulez-vous vraiment annuler cette facture ?')) {
                const id = Number.parseInt(btn.dataset.invoice, 10);
                spinner.removeAttribute('hidden');
                fetch(`${localStorage.getItem('baseUrl')}/annulerfacture`, {
                    method: 'POST',
                    body: JSON.stringify({invoiceId: id})
                }).then(response => {
                    if (response.ok) {
                        response.text().then(resp => {
                            const { message, data } = JSON.parse(resp);
                            spinner.setAttribute('hidden', 'hidden');
                            showAlert(message, 'success');
                        });
                    } else {
                        console.error(response);
                    }
                });
            }
        })
    })
};

invoicesDatatable.addEventListener('render.mdb.datatable', setActions);

const invoicesTableInstance = new mdb.Datatable(invoicesDatatable, {
    columns: [
        { label: 'Date', field: 'dateFact' },
        { label: 'N° facture', field: 'id' },
        { label: 'Type', field: 'typeFacture' },
        { label: 'Client', field: 'nomClient' },
        { label: 'Montant', field: 'total' },
        { label: 'Action', field: 'action', sort: false },
    ],
    rows: invoices.map((row) => {
        return {
            ...row,
            dateFact: `${(new Date(row.dateFact.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'long', day: 'numeric'})}`,
            total: `${row.total.toFixed(2)} ${currency}`,
            action: `<button class="cancel-invoice btn border border-primary btn-floating btn-sm" data-invoice="${row.id}"><i class="fa fa-undo"></i></button>`
        };
    }),
}, { hover: true });

document.getElementById('datatable-search-input').addEventListener('input', (e) => {
    invoicesTableInstance.search(e.target.value);
});
