<?php

namespace App\Controller;

use App\AbstractController;
use App\Repository\MaisonRepository;
use App\Repository\ValueAddedTaxRepository;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

class ValueAddedTaxController extends AbstractController
{
    /**
     * @Route("/vats", name="vats_list")
     */
    public function list(Request $request): Response
    {
        $entityManager = $this->getDoctrine()->getManager();
        $strLimit = $request->get('limit');
        $searchQuery = $request->get('search');
        $limit = isset($strLimit) && is_string($strLimit) ? intval($strLimit) : 200;
        $queryString = "SELECT v.id, v.rate, v.amount, v.createdAt, s.name as product, ph.quantity, ph.price, pos.name as posName, i.id as invoiceId FROM App\Entity\ValueAddedTax v ";

        if (isset($searchQuery)) {
            $queryString .= "WHERE s.name LIKE :product ";
        }

        $query = $entityManager->createQuery($queryString . "LEFT JOIN v.posHistory ph LEFT JOIN ph.pos pos LEFT JOIN ph.invoice i LEFT JOIN ph.service s ORDER BY v.createdAt DESC");

        if (isset($searchQuery)) {
            $query = $query->setParameter('product', '%'.$searchQuery.'%');
        }

        $vats = $query->setMaxResults($limit)->getResult();

        return $this->render('vats/list.html.twig', [
            'title' => 'Rapport TVA',
            'breadcrumb' => [
                ['name' => 'Rapport TVA']
            ],
            'vats' => $vats
        ]);
    }

    /**
     * @Route("/vats/config", name="config_vat_rate")
     */
    public function config(Request $request, MaisonRepository $companyRepository): Response
    {
        $company = $companyRepository->findAll()[0];

        if ($request->isMethod('POST')) {
            $company->setVatRate(\floatval($request->request->get('vatRate')) / 100);
            $companyRepository->save($company, true);
        }

        return $this->render('vats/config.html.twig', [
            'title' => 'Configuration du taux de la TVA',
            'breadcrumb' => [
                ['name' => 'Configuration du taux de la TVA']
            ],
            'vatRate' => $company->getVatRate()
        ]);
    }
}
