const vehiclesDatatable = document.getElementById('vehicles-datatable');
const vehicles = JSON.parse(vehiclesDatatable.dataset.vehicles);

const vehiclesTableInstance = new mdb.Datatable(vehiclesDatatable, {
    columns: [
        { label: 'Immatriculation', field: 'numeroImmatriculation' },
        { label: 'Fabrication', field: 'anneeFabrication' },
        { label: 'En circulation', field: 'dateMiseEnCirculation' },
        { label: 'Genre', field: 'genre' },
        { label: 'Marque', field: 'marque' },
        { label: 'Type', field: 'typeOuModele' },
        { label: 'Puissance', field: 'puissance' },
        { label: 'Num. série', field: 'numeroDansLaSerie' },
        { label: 'Energie', field: 'energie' },
        { label: 'Kilométrage', field: 'kilometrage' },
        { label: 'Usage', field: 'usageVehicule' },
        { label: 'Couleur', field: 'couleur' },
        { label: 'Chassis', field: 'numeroChassis' },
        { label: 'Moteur', field: 'numeroMoteur' },
        { label: 'Client', field: 'nomClient' }
    ],
    rows: vehicles.map(row => {
        return {
            ...row,
            numeroImmatriculation: `<a href="/vehicule/${row.id}">${row.numeroImmatriculation}</a>`
        }
    },
    { hover: true })
},);

document.getElementById('datatable-search-input').addEventListener('input', (e) => {
    vehiclesTableInstance.search(e.target.value);
});
