const vatsDatatable = document.getElementById('vats-datatable');
let vats = JSON.parse(vatsDatatable.dataset.vats);

const loadFromServer = async (query) => {
    const q = query.trim();
    const url = `${localStorage.getItem('baseUrl')}/vats?search=${encodeURI(q)}&limit=200`;
    let response = await fetch(url, {
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    });
    let data = await response.json();

    return data;
};

const setVats = (vats) => {
    return vats.map(row => {
        const qty = Math.abs(row.quantity);
        return {
            ...row,
            date: (new Date(row.createdAt.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'short', day: 'numeric'}),
            amount: row.amount.toFixed(2),
            quantity: qty,
            total: qty * row.price.toFixed(2),
            rate: (row.rate * 100).toFixed(2) + '%'
        }
    });
};

const vatsTableInstance = new mdb.Datatable(vatsDatatable, {
    columns: [
        { label: 'Date', field: 'date' },
        { label: 'Montant', field: 'amount' },
        { label: 'Produit', field: 'product' },
        { label: 'Qté', field: 'quantity' },
        { label: 'Montant', field: 'total' },
        { label: 'N° Facture', field: 'invoiceId' },
        { label: 'Point de vente', field: 'posName' },
        { label: 'Taux TVA', field: 'rate' }
    ],
    rows: setVats(vats)
}, { loading: false });

const loadData = (value) => {
    const filteredVats = vats.filter(vat => vat.product.trim().toLowerCase().indexOf(value) > -1);
    const updateTable = (data) => {
        vatsTableInstance.update({ rows: setVats(data) }, { loading: false });
    }
    loadFromServer(value).then((data) => {
        if (filteredVats.length < data.length) {
            updateTable(data);
        }
        vats = data;
    });
    updateTable(filteredVats);
};

document.getElementById('datatable-search-input').addEventListener('input', (event) => {
    const value = event.currentTarget.value;
    if (value.length > 1) {
        vatsTableInstance.update(null, { loading: true });
        loadData(value);
    }
});
