import './styles/sale.css';
// import './styles/print.min.css';
import {
    printInvoiceStyles,
    printReceiptExpertiseStyles,
    printReceiptPvControleStyles,
    printClosingReportStyles,
    printReceiptDebtsStyles,
    printReceiptBailStyles,
    printDailyReportStyles
} from './print-styles';
import './bootstrap/js/bootstrap';
import './app';
// import './jquery';
// import './jQuery.print';
// import './print';
import printJS from 'print-js';
// import './print.min';
import { FullySpelledOut } from './fully-spelled-out';
import { groupArrayOfObjects, toCamelCase, step, formatNumber } from './functions';
import { downloadFile } from './functions';
import { getFileFromServer } from './functions';

// const path = require('path');
const bodyElt = document.body;
const bodyEltDataset = bodyElt.dataset;
// const companyLogo = bodyEltDataset.companyLogo;
const user = bodyEltDataset.dbUser;
let categories = JSON.parse(bodyEltDataset.dbCategories);
let services = JSON.parse(bodyEltDataset.dbServices).map(service => Object.assign(service, {selectedPrice: service.unitPrice}));
const discountables = JSON.parse(bodyEltDataset.dbDiscountables);
const bonusThreshold = Number.parseInt(bodyEltDataset.dbNbSalesBonus, 10);
const bonusPercentage = Number.parseFloat(bodyEltDataset.dbBonusPercentage);
const maison = JSON.parse(bodyEltDataset.dbCompany);
const bankAccounts = JSON.parse(bodyEltDataset.dbBankAccounts);
const pos = bodyEltDataset.dbPos;
const ttcAmountElt = document.querySelector('#net-ttc');
const permissions = JSON.parse(bodyEltDataset.dbPermissions);
let cloture = JSON.parse(bodyEltDataset.dbCloture);
const invoiceList = document.querySelector('#factureslist');
const licenseList = document.querySelector('#license-list');
const invoiceListDatatable = invoiceList.querySelector('.datatable');
const licenseListDatatable = licenseList.querySelector('.datatable');
let invoicesTableInstance;
let licensesTableInstance;
let companyLogo;

let exchangeRate = ((rate) => {
    if (typeof rate === 'string') {
        if (rate === '') {
            return undefined;
        }
        rate = Number.parseFloat(rate);
    }
    return rate;
})(bodyEltDataset.dbExchangeRate);

let clients = JSON.parse(bodyEltDataset.dbClients).map(client => {
    client.totalFactures = Number.parseInt(client.totalFactures, 10);
    client.totalBonus = Number.parseFloat(client.totalBonus);
    client.totalCaution = Number.parseFloat(client.totalCaution);
    return client;
});

let workforcePercent = Number.parseFloat(bodyEltDataset.dbWorkforcePercent);
let vehicles = JSON.parse(bodyEltDataset.dbVehicles);
let usagesVehicule = ['Usage personnel', 'Transport des personnes', 'Transport des biens', 'Usage humanitaire', 'Véhicules spéciaux'];
// let currency = localStorage.getItem('currency') ?? bodyEltDataset.dbCurrency;
let currency = bodyEltDataset.dbCurrency;
let total = 0;
let workforce = 0;
let discount = 0;
let net = 0;
let client = { id: null };
let licenseId = 0;
let currentService;
let currentInvoice = { id: null, client: { id: null }, articles: {}, services: {}, total: 0, workforce: 0, discount: 0 };
let selectedDebts = [];
let amountPaid = 0;
let amountDueSold;
let amountPaidDebts = 0;
let clotureElts = [];
let licenses = [];
let expertises = [];
let departmentProductArr = [];
const paperFormats = [
    { key: 'roll58', name: 'Roll Paper 58 mm', maxWidth: 272 },
    { key: 'roll80', name: 'Roll Paper 80 mm', maxWidth: 320 },
    { key: 'a4', name: 'A4 210 x 297 mm', maxWidth: 1100 }
];
const storedInvoiceSettings = localStorage.getItem('invoiceSettings');
const invoiceListUrl = `${localStorage.getItem('baseUrl')}/factures/vente/guichetier`;
const licenseListUrl = `${localStorage.getItem('baseUrl')}/licenses/guichetier`;
let invoiceSettings = storedInvoiceSettings === null ? { paperFormat: paperFormats[permissions.includes('facture-a4') ? 2 : 0], displayLogo: 'on', invoiceTelephone: 'on', invoiceEmail: 'on' } : JSON.parse(storedInvoiceSettings);
const companyHasVat = typeof maison.vatRate === 'number' && maison.vatRate > 0;

const clientAutocomplete = document.querySelector('#client-autocomplete');
const clientDropdownMenu = document.querySelector('#client-dropdown');
const serviceAutocomplete = document.querySelector('#service-autocomplete');
const usageVehiculeDropdownMenu = document.querySelector('#usage-vehicule-dropdown');
const immatriculationAutocompletes = document.querySelectorAll('#numeroImmatriculation, #vehicule-controle, #vehicule-expertise');
const grid = document.querySelector('#grid');
const gridContent = document.querySelector('#gridContent');
const newCustomerForm = document.querySelector('#newCustomerForm');
const invoiceCustomizationModalElt = document.querySelector('#invoice-customization-modal');
const priceSelectModalElt = document.querySelector('#price-select-modal');
const priceSelectModal = new mdb.Modal(priceSelectModalElt);
const invoiceCustomizationModal = new mdb.Modal(invoiceCustomizationModalElt);
const cautionDepositModal = new mdb.Modal(document.getElementById('caution-deposit-modal'));
const depenseModal = new mdb.Modal(document.getElementById('newDepense'), {});
const printReceiptModal = new mdb.Modal(document.getElementById('confirm-print-receipt'), {});
const newControleModalElt = document.querySelector('#new-ct-modal');
const newControleModal = new mdb.Modal(newControleModalElt, {});
const newExpertiseModal = new mdb.Modal(document.querySelector('#new-expertise-modal'), {});

const clientsFilter = async (value) => {
    const query = value.trim().toLowerCase();
    const filteredClients = clients.filter(client => client.nomClient.toLowerCase().includes(query));

    loadClientsFromServer(query).then((data) => {
        // clients.splice(0, data.length, ...data);
        clients = data;
    });

    return filteredClients;
};

const usagesVehiculeFilter = async (value) => usagesVehicule.filter(u => u.toLowerCase().includes(value.trim().toLowerCase()));

const vehiclesFilter = async (value) => {
    const query = value.trim().toLowerCase();
    const filteredVehicles = vehicles.filter(vehicle => vehicle.numeroImmatriculation.toLowerCase().includes(query));

    loadVehiclesFromServer(query).then((data) => {
        vehicles = data.matches;
    });

    return filteredVehicles;
};

const servicesFilter = (value) => {
    const query = value.trim().toLowerCase();
    const filteredServices = services.filter(service => (null !== service.codeBars && service.codeBars?.includes(query)) || service.name.trim().toLowerCase().indexOf(query) > -1);

    loadFromServer(query).then((data) => {
        if (services.length < data.length) {
            updateGrid(data.map(serv => {
                if (serv.type === 2) {
                    const service = findServiceById(serv.serviceId);
                    if ('undefined' !== typeof service) {
                        Object.assign(serv, {quantity: service.quantity});
                    }
                }
                return Object.assign(serv, {selectedPrice: serv.unitPrice});
            }));
        }
        if (data.length > 0 && data[0].codeBars?.includes(sessionStorage.getItem('barcode'))) {
            currentInvoice = addToCart(data[0].serviceId, 1, currentInvoice);
            document.getElementById('serviceinputautofocus').value = '';
            document.getElementById('serviceinputautofocus').focus();
        }
    });

    updateGrid(filteredServices);

    return filteredServices;
};

const loadFromServer = async (query) => {
    const q = query.trim();
    sessionStorage.setItem('barcode', q);
    const response = await fetch(`${localStorage.getItem('baseUrl')}/services?search=${encodeURI(q)}&limit=24`, {
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    });
    const data = await response.json();
    return data;
};

const loadClientsFromServer = async (searchQuery) => {
    const q = searchQuery.trim();
    const url = `${localStorage.getItem('baseUrl')}/clients?search=${encodeURI(q)}`;
    const response = await fetch(url, {
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    });
    const data = await response.json();
    return data.data;
};

const loadVehiclesFromServer = async (searchQuery) => {
    const q = searchQuery.trim();
    const url = `${localStorage.getItem('baseUrl')}/vehicules?search=${encodeURI(q)}`;
    const response = await fetch(url, {
        headers: new Headers({'X-Requested-With': 'XMLHttpRequest'})
    });
    const data = await response.json();
    return data.data;
};

const disableCustomerDetailsButtons = (detailsBtn, cautionBtn) => {
    document.querySelector('#' + detailsBtn).disabled = 'disabled';
    document.querySelector('#' + cautionBtn).disabled = 'disabled';
};

const enableCustomerDetailsButtons = (detailsBtn, cautionBtn) => {
    document.querySelector('#' + detailsBtn).removeAttribute('disabled');
    document.querySelector('#' + cautionBtn).removeAttribute('disabled');
};

const showLatestVehicles = (vehiclesList) => {
    let vehiclesListElt = document.querySelector('#vehicles-modal .modal-content > .modal-body > .tab-content > .tab-pane:first-child > div:last-child > .list-group');
    // vehiclesList = vehiclesList.slice(0, 15);
    vehiclesListElt.innerHTML = '';
    for (let idx = 0; idx < 12; idx++) {
        if (typeof vehiclesList[idx] !== 'undefined') {
            vehiclesListElt.innerHTML += `
                <a class="list-group-item list-group-item-action d-flex justify-content-between" href="#">
                    <span>${vehiclesList[idx]['genre']} (${vehiclesList[idx]['numeroImmatriculation']})</span>
                </a>
            `;
        }
    }
};

const populateLicensesTable = (data) => {
    const datatable = document.querySelector('#ct-pill-content > .card > .datatable');
    const rows = [];
    licenses = data;

    if (licenses.length > 0) {
        for (const idx in licenses) {
            rows.push([
                Number.parseInt(idx, 10) + 1,
                licenses[idx].numeroPv,
                `${licenses[idx].numeroImmatriculation} (${licenses[idx].genre})`,
                licenses[idx].nomClient,
                (new Date(licenses[idx].createdAt.date)).toLocaleDateString('fr-Fr', { year: 'numeric', month: 'short', day: 'numeric' }),
                (new Date(licenses[idx].prochainevisite.date)).toLocaleDateString('fr-Fr', { year: 'numeric', month: 'short', day: 'numeric' }),
                `<i class="fas fa-eye" style="cursor: pointer"></i>`
            ]);
        }
    }

    datatable.innerHTML = '';
    datatable.dataset.maxHeight = 400;

    const ctDatatableInstance = new mdb.Datatable(datatable, {
        columns: ['#', 'Numéro PV', 'Véhicule', 'Propriétaire', 'Création', 'Expiration', 'Action'],
        rows: rows
    });

    document.getElementById('ct-search-input').addEventListener('input', (e) => {
        ctDatatableInstance.search(e.target.value);
    });
};

const populateExpertisesTable = (data) => {
    const datatable = document.querySelector('#ev-pill-content > .card > .datatable');
    const rows = [];
    expertises = data;

    if (expertises.length > 0) {
        for (const idx in expertises) {
            rows.push([
                Number.parseInt(idx, 10) + 1,
                (new Date(expertises[idx].createdAt.date)).toLocaleDateString('fr-Fr', { year: 'numeric', month: 'short', day: 'numeric' }),
                `${expertises[idx].numeroImmatriculation} (${expertises[idx].genre})`,
                expertises[idx].nomClient,
                expertises[idx].username,
                `<i class="fas fa-eye" style="cursor: pointer"></i>`
            ]);
        }
    }
    datatable.innerHTML = '';
    datatable.dataset.maxHeight = 400;

    const evDatatableInstance = new mdb.Datatable(datatable, {
        columns: ['#', 'Date', 'Véhicule', 'Propriétaire', 'Faite par', 'Action'],
        rows: rows
    });

    document.getElementById('ev-search-input').addEventListener('input', (e) => {
        evDatatableInstance.search(e.target.value);
    });
};

window.showVehiclesModal = function() {
    let options = '';
    const spinner = document.querySelector('#spinner');
    const newVehicleModal = new mdb.Modal(document.querySelector('#vehicles-modal'), {});
    // const clientSelect = document.querySelector('#client');
    const vehicleSelect = document.querySelector('#vehicule-controle');

    // populate client select
    // clients.forEach(c => {
    //     options += `<option value="${c.id}"${Number.parseInt(clientSelect.value) === c.id ? ' selected' : ''}>${c.nomClient}</option>`;
    // });
    // clientSelect.innerHTML = options;

    spinner.removeAttribute('hidden');
    // fetch vehicles
    fetch(`${localStorage.getItem('baseUrl')}/vehicules`, {
        method: 'GET',
        headers: new Headers({ 'X-Requested-With': 'XMLHttpRequest' })
    }).then(resp => {
        if (resp.ok) {
            resp.text().then(responseBody => {
                const { latest, matches } = JSON.parse(responseBody).data;
                vehicles = matches;
                // populate vehicle select
                options = '';
                latest.forEach(v => {
                    options += `<option value="${v.id}"${Number.parseInt(vehicleSelect.value) === v.id ? ' selected' : ''}>${v.genre} (${v.numeroImmatriculation})</option>`;
                });
                vehicleSelect.innerHTML = options;
                // fetch licenses
                fetch(`${localStorage.getItem('baseUrl')}/licences`, {
                    method: 'GET',
                    headers: new Headers({ 'X-Requested-With': 'XMLHttpRequest' })
                }).then(resp => {
                    if (resp.ok) {
                        resp.text().then(responseBody => {
                            licenses = JSON.parse(responseBody).data;
                            // fetch expertises
                            fetch(`${localStorage.getItem('baseUrl')}/expertises`, {
                                method: 'GET',
                                headers: new Headers({ 'X-Requested-With': 'XMLHttpRequest' })
                            }).then(resp => {
                                if (resp.ok) {
                                    resp.text().then(responseBody => {
                                        expertises = JSON.parse(responseBody).data;
                                        populateExpertisesTable(expertises);
                                        // showLatestLicenses(licenses);
                                    });
                                }
                            }).catch(() => {
                                spinner.setAttribute('hidden', 'hidden');
                                showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
                            });
                            populateLicensesTable(licenses);
                        });
                    }
                }).catch(() => {
                    spinner.setAttribute('hidden', 'hidden');
                    showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
                });

                showLatestVehicles(latest);
                spinner.setAttribute('hidden', 'hidden');
                newVehicleModal.show();
            });
        }
    }).catch(() => {
        spinner.setAttribute('hidden', 'hidden');
        showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
    });
}

window.resetVehicleForm = function(event) {
    event.preventDefault();
    document.querySelector('#numeroImmatriculation').removeAttribute('data-id');
    document.querySelector('#client').removeAttribute('data-client-id');
    document.querySelectorAll('#new-vehicle-form input').forEach(input => {
        input.value = '';
    });
}

window.saveVehicle = function() {
    const immatriculationInput = document.querySelector('#numeroImmatriculation');
    const clientInput = document.querySelector('#client');

    if (immatriculationInput.value.trim() === '') {
        showAlert('Le numéro d\'immatriculation est obligatoire', 'danger', false);
    } else if (clientInput.value.trim() === '' || clientInput.dataset.clientId.trim() == '' || typeof clientInput.dataset.clientId === 'undefined') {
        showAlert('Le nom du client est obligatoire', 'danger', false);
    } else {
        const payload = {};
        const vehicleId = immatriculationInput.dataset.id;
        const spinner = document.querySelector('#spinner');
        for (const pair of (new FormData(document.querySelector('#new-vehicle-form'))).entries()) {
            Object.assign(payload, {
                [pair[0]]: (pair[0] === 'client' ? clientInput.dataset.clientId : pair[1])
            });
        }
        spinner.removeAttribute('hidden');
        fetch(`${localStorage.getItem('baseUrl')}/vehicule/${'undefined' === typeof vehicleId ? 'new' : vehicleId}`, {
            method: 'POST',
            headers: new Headers({ 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' }),
            body: JSON.stringify(payload)
        }).then(response => {
            if (response.ok) {
                response.text().then(responseBody => {
                    const { message, data } = JSON.parse(responseBody);
                    // vehicles.unshift(vehicle);
                    spinner.setAttribute('hidden', 'hidden');
                    showLatestVehicles(data);
                    showAlert(message, 'success', false);
                });
            }
        }).catch(() => {
            spinner.setAttribute('hidden', 'hidden');
            showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
        });
    }
}

window.savePv = function() {
    const payload = {
        vehicule: Number.parseInt(document.querySelector('#vehicule-controle').dataset.id, 10),
        article: Number.parseInt(document.getElementById('article-controle').value, 10),
        totalCost: Number.parseFloat(document.getElementById('total-cost-license').value),
        amountPaid: Number.parseFloat(document.getElementById('amount-paid-license').value)
    };

    const spinner = document.querySelector('#spinner');
    spinner.removeAttribute('hidden');

    fetch(`${localStorage.getItem('baseUrl')}/licence/new`, {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' }),
        body: JSON.stringify(payload)
    }).then(response => {
        if (response.ok) {
            response.text().then(async (responseBody) => {
                const data = JSON.parse(responseBody);
                // const divtoprint = document.querySelector('#recu-controle-technique');
                // const vehicle = vehicles.find(v => v.id === Number.parseInt(payload.vehicule, 10));
                // divtoprint.innerHTML = `
                //     <div id="recu-controle-technique-body">
                //         <div>Client : ${data.data.nomClient}</div>
                //         <div>Modèle : ${data.data.typeOuModele}</div>
                //         <div>Marque : ${data.data.marque}</div>
                //         <div class="font-weight-bold">Plaque : ${data.data.numeroImmatriculation}</div>
                //         <div class="font-weight-bold">Cout de la licence : ${data.sommesent * getRate(currency)} ${currency}</div>
                //         <div class="font-weight-bold">Montant payé : ${data.data.installment * getRate(currency)} ${currency}</div>
                //         <div>Reçu par : ${data.doneby}</div>
                //         <div>Date : ${data.createdat}</div>
                //     </div>
                // `;
                // divtoprint.innerHTML += generateNalediSignature();
                spinner.setAttribute('hidden', 'hidden');
                newControleModal.hide();
                licenses.unshift(data.data);
                populateLicensesTable(licenses);
                await printLicenseReceipt(data.data.id, { totalCost: payload.totalCost, amountPaid: payload.amountPaid });
                // divtoprint.removeAttribute('hidden');

                // printJS({
                //     printable: 'recu-controle-technique',
                //     type: 'html',
                //     header: `
                //         ${generateDocumentHeader('receipt')}
                //         <h3 class="text-center border">REÇU N° ${data.data.id}</h3>
                //         <h3 class="text-center border-bottom-dashed">PV CONTRÔLE TECHNIQUE</h3>
                //     `,
                //     maxWidth: invoiceSettings.paperFormat.maxWidth,
                //     styles: printReceiptPvControleStyles
                // });

                // divtoprint.setAttribute('hidden', 'hidden');
                showAlert(data.message, 'success', false);
            });
        }
    }).catch(() => {
        spinner.setAttribute('hidden', 'hidden');
        showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
    });
}

window.saveExpertise = function() {
    const payload = { vehicule: document.getElementById('vehicule-expertise').dataset.id };
    const spinner = document.querySelector('#spinner');
    spinner.removeAttribute('hidden');

    fetch(`${localStorage.getItem('baseUrl')}/expertises/new`, {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' }),
        body: JSON.stringify(payload)
    }).then(resp => {
        if (resp.ok) {
            resp.text().then(async (responseBody) => {
                const data = JSON.parse(responseBody);
                const divtoprint = document.querySelector('#recu-expertise');
                spinner.setAttribute('hidden', 'hidden');
                newExpertiseModal.hide();
                expertises.unshift(data.data);
                populateExpertisesTable(expertises);

                divtoprint.innerHTML = `
                    <div id="recu-expertise-body">
                        <div>Client : ${data.data.nomClient}</div>
                        <div>Modèle : ${data.data.typeOuModele}</div>
                        <div>Marque : ${data.data.marque}</div>
                        <div class="font-weight-bold">Plaque : ${data.data.numeroImmatriculation}</div>
                        <div class="font-weight-bold">Montant payé : ${data.amountPaid * getRate(currency)} ${currency}</div>
                        <div>Reçu par : ${data.data.user}</div>
                        <div>Date : ${(new Date(data.data.createdAt.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'long', day: 'numeric'})}</div>
                    </div>
                `;

                divtoprint.innerHTML += generateNalediSignature();
                divtoprint.removeAttribute('hidden');

                printJS({
                    printable: 'recu-expertise',
                    type: 'html',
                    header: `
                        ${await generateDocumentHeader('receipt')}
                        <h3 class="text-center border">REÇU N° ${data.data.id}</h3>
                        <h3 class="font-weight-bold text-center border-bottom-dashed mb-2">EXPERTISE DE VÉHICULE</h3>
                    `,
                    maxWidth: invoiceSettings.paperFormat.maxWidth,
                    style: `
                            * {
                            font-family: monospace;
                            /* font-size: smaller !important; */
                        }
                    
                        #recu-expertise,
                        #recu-expertise-body > div {
                            width: 100% !important;
                        }
                    
                        /* #debt-payment-receipt-body {
                            display: flex;
                            flex-direction: column;
                            align-items: center;
                        } */
                    
                        .text-center {
                            text-align: center;
                        }
                    
                        .font-weight-bold {
                            font-weight: bold;
                        }
                    
                        .border {
                            border: 1px solid #000;
                        }
                    
                        .border-bottom-dashed {
                            border-bottom: 1px dashed #000;
                        }
                    
                        .border-top-dashed {
                            border-top: 1px dashed #000;
                        }
                    
                        .py-2 {
                            padding-top: 1.2em;
                            padding-bottom: 1.2em;
                        }
                    
                        .mt-3 {
                            margin-top: 1.8em;
                        }
                    
                        .mt-2 {
                            margin-top: 1.2em;
                        }
                    
                        .mb-2 {
                            margin-bottom: 1.2em;
                        }
                    
                        .pt-2 {
                            padding-top: 1.2em;
                        }
                    
                        .w-100 {
                            width: 100% !important;
                        }
                    
                        .w-90 {
                            width: 90% !important;
                        }
                    
                        .w-75 {
                            width: 75% !important;
                        }
                    
                        .w-70 {
                            width: 70% !important;
                        }
                    
                        .w-60 {
                            width: 60% !important;
                        }
                    
                        .w-50 {
                            width: 50% !important;
                        }
                    
                        .w-40 {
                            width: 40 !important;
                        }
                    
                        .w-30 {
                            width: 30% !important;
                        }
                    
                        .w-25 {
                            width: 25% !important;
                        }
                    
                        #print-naledi-signature {
                            text-align: center;
                            width: 100% !important;
                            border-top: 1px dashed #000;
                            margin-top: 10px;
                            font-size: smaller;
                        }
                    `
                });

                divtoprint.setAttribute('hidden', 'hidden');
                showAlert(data.message, 'success', false);
            });
        }
    }).catch(() => {
        spinner.setAttribute('hidden', 'hidden');
        showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
    });
}

const setPhysicalPersonInputs = (index = 0) => {
    let options = `
        <label for="employeur">Employeur</label>
        <select name="employeur" id="employeur" class="form-control">
            <option value="0"${0 === index ? ' selected' : ''}>Aucun</option>
    `;

    clients.filter(c => c.typeClient === 'morale').forEach(client => {
        options += `
            <option value="${client['nomClient']}"${1 === index && client.nomClient === currentInvoice.client.employeur ? ' selected' : ''}>
                ${client['nomClient']}
            </option>
        `;
    });
    options += '</select>';
    document.querySelector('#gender-section').innerHTML = `
        <div class="form-group my-2 w-50 mr-2">
            <label for="sexe">Sexe</label>
            <select type="text" name="sexe" id="sexe" class="form-control">
                <option value="Aucun">Aucun</option>
                <option value="H"${1 === index && 'H' === currentInvoice.client.sexe ? ' selected' : ''}>Homme</option>
                <option value="F"${1 === index && 'F' === currentInvoice.client.sexe ? ' selected' : ''}>Femme</option>
            </select>
        </div>
        <div class="form-group my-2 w-50 ml-2">
            <label for="etatCivil">Etat civil</label>
            <select name="etatCivil" id="etatCivil" class="form-control">
                <option value="Aucun">Aucun</option>
                <option value="celibataire"${1 === index && 'celibataire' === currentInvoice.client.etatCivil ? ' selected' : ''}>Célibataire</option>
                <option value="marie"${1 === index && 'marie' === currentInvoice.client.etatCivil ? ' selected' : ''}>Marié(e)</option>
                <option value="divorce"${1 === index && 'divorce' === currentInvoice.client.etatCivil ? ' selected' : ''}>Divorcé(e)</option>
                <option value="veuf"${1 === index && 'veuf' === currentInvoice.client.etatCivil ? ' selected' : ''}>Veuf(ve)</option>
            </select>
        </div>
    `;
    document.querySelector('#employer-section').innerHTML = options;
};

const removePhysicalPersonInputs = () => {
    document.querySelector('#gender-section').innerHTML = '';
    document.querySelector('#employer-section').innerHTML = '';
};

const serviceExistence = (arr, fn) => {
    for (const value of arr) {
        if (fn(value)) {
            return value;
        }
    }
    return false;
};

function getRate(c) {
    const rate = c === bodyEltDataset.dbCurrency ? 1 : exchangeRate;
    return rate;
}

window.changeCurrency = function(event) {
    showAlert('Cette fonctionnalité n\'est pas disponible.', 'warning', false);
    // const currencyChangeInvoice = {};
    // Object.assign(currencyChangeInvoice, currentInvoice);

    // for (const key in currentInvoice.articles) {
    //     const article = currentInvoice.articles[key];
    //     addToCart(article.serviceId, (0 - article.nbUnites), currentInvoice, article.selectedPrice);
    // }

    // for (const key in currentInvoice.services) {
    //     const service = currentInvoice.services[key];
    //     addToCart(service.serviceId, (0 - service.nbUnites), currentInvoice, service.selectedPrice);
    // }

    // if (typeof exchangeRate === 'undefined') {
    //     showAlert('Le taux de change n\'est pas défini.', 'warning', false);
    // } else {
    //     if (currency === '$US') {
    //         currency = 'CDF';
    //         event.currentTarget.innerHTML = '$US';
    //     } else {
    //         currency = '$';
    //         event.currentTarget.innerHTML = 'CDF';
    //     }
    // }

    // updateGrid(services);
    // localStorage.setItem('currency', currency);
    // document.querySelector('#total-bonus').textContent = ((currentInvoice.client.totalBonus ?? 0) * getRate(currency)).toFixed(2);
    // document.querySelector('#total-caution').textContent = ((currentInvoice.client.totalCaution ?? 0) * getRate(currency)).toFixed(2);

    // for (const key in currencyChangeInvoice.articles) {
    //     const article = currencyChangeInvoice.articles[key];
    //     addToCart(article.serviceId, (0 - article.nbUnites), currentInvoice, article.selectedPrice);
    // }

    // for (const key in currencyChangeInvoice.services) {
    //     const service = currencyChangeInvoice.services[key];
    //     addToCart(service.serviceId, (0 - service.nbUnites), currentInvoice, service.selectedPrice);
    // }
};

function formatDate(dateString) { // format a date string to YYYY-mm-dd
    let dateObject = new Date(dateString);
    dateObject = new Date(dateObject.getFullYear(), dateObject.getMonth(), dateObject.getDate() + 1);

    return dateObject.toJSON()?.split('T')[0];
}

function searchInvoicesLocal(savedInvoiceItems, sq, criteria, search = false) {
    let query = sq;
    const invoices = savedInvoiceItems.filter((item) => { // Filtered invoices
        let comparisonResult = false;
        // console.log(sq);
        criteria.forEach((criterion) => {
            let compField;
            if (criterion.type === 'string' && item[criterion.field] !== null) {
                compField = item[criterion.field].toLowerCase();
            } else if (criterion.type === 'number') {
                compField = item[criterion.field] + '';
            } else if (criterion.type === 'object' && typeof criterion.subfield !== 'undefined') {
                if (search && query.split(' ').length > 1 && criterion.subfield === 'date') {
                    const q = formatDate(query);
                    if (typeof q !== 'undefined') {
                        query = q;
                    }
                }
                compField = item[criterion.field][criterion.subfield];
            }
            if (typeof compField !== 'undefined') {
                comparisonResult = comparisonResult || (criterion.exact ? compField === query : compField.indexOf(query) > -1);
            }
        });
        // console.log(query);
        return comparisonResult;
    });

    return { invoices, query };
}

function searchLicensesLocal(savedLicenses, sq, criteria, search = false) {
    let query = sq;
    const licenses = savedLicenses.filter((item) => { // Filtered licenses
        let comparisonResult = false;
        // console.log(sq);
        criteria.forEach((criterion) => {
            let compField;
            if (criterion.type === 'string' && item[criterion.field] !== null) {
                compField = item[criterion.field].toLowerCase();
            } else if (criterion.type === 'number') {
                compField = item[criterion.field] + '';
            } else if (criterion.type === 'object' && typeof criterion.subfield !== 'undefined') {
                if (search && query.split(' ').length > 1 && criterion.subfield === 'date') {
                    const q = formatDate(query);
                    if (typeof q !== 'undefined') {
                        query = q;
                    }
                }
                compField = item[criterion.field][criterion.subfield];
            }
            if (typeof compField !== 'undefined') {
                comparisonResult = comparisonResult || (criterion.exact ? compField === query : compField.indexOf(query) > -1);
            }
        });
        // console.log(query);
        return comparisonResult;
    });

    return { licenses, query };
}

async function searchInvoices(savedInvoiceItems, searchQuery, criteria, search = false) {
    const { invoices, query } = searchInvoicesLocal(savedInvoiceItems, searchQuery, criteria, search);
    updateInvoices(invoices, currency);
    // console.log(query)
    const response = await fetch(`${invoiceListUrl}?${search ? 'search' : 'date'}=${query}`, { method: 'GET' });
    const data = await response.text();
    let serverInvoices = JSON.parse(data);

    serverInvoices = serverInvoices.filter((invoice) => {
        const result = invoices.find((i) => {
            return criteria.every((criterion) => {
                const isEqual = typeof criterion.subfield === 'undefined' ? i[criterion.field] === invoice[criterion.field] : i[criterion.field][criterion.subfield] === invoice[criterion.field][criterion.subfield];
                return isEqual;
            });
        });
        return typeof result === 'undefined';
    });

    savedInvoiceItems.push(...serverInvoices);
    localStorage.setItem('invoiceItems', JSON.stringify(savedInvoiceItems));
    invoices.push(...serverInvoices);

    return invoices;
}

async function searchLicenses(savedLicenses, searchQuery, criteria, search = false) {
    // console.log(searchQuery);
    const { licenses, query } = searchLicensesLocal(savedLicenses, searchQuery, criteria, search);
    updateLicenses(licenses, currency);
    // console.log(query)
    const response = await fetch(`${licenseListUrl}?${search ? 'search' : 'date'}=${query}`, { method: 'GET' });
    const data = await response.text();
    console.log(data);
    let serverLicenses = JSON.parse(data);

    serverLicenses = serverLicenses.filter((license) => {
        const result = licenses.find((l) => {
            return criteria.every((criterion) => {
                const isEqual = typeof criterion.subfield === 'undefined' ? l[criterion.field] === license[criterion.field] : l[criterion.field][criterion.subfield] === license[criterion.field][criterion.subfield];
                return isEqual;
            });
        });
        return typeof result === 'undefined';
    });

    savedLicenses.push(...serverLicenses);
    // console.log(savedLicenses);
    // localStorage.setItem('licenses', JSON.stringify(savedLicenses));
    licenses.push(...serverLicenses);

    return licenses;
}

function updateInvoices(invoicesData, currency) {
    invoicesTableInstance.update({
        rows: invoicesData.map(row => {
            return {
                ...row,
                dateFact: `${(new Date(row.dateFact.date)).toLocaleDateString('en-US', {year: 'numeric', month: 'long', day: 'numeric'})}`,
                amount: `${((row.total + (row.vatAmount ?? 0) + ('number' === typeof row.workforce ? row.workforce : 0)) * getRate(currency)).toFixed(2)} ${currency}`,
                discount: `${((row.discount ?? 0) * getRate(currency)).toFixed(2)} ${currency}`
            };
        })
    }, { loading: false, hover: true });

    invoiceListDatatable.querySelectorAll('tbody > tr').forEach((rowElt) => {
        rowElt.style.cursor = 'pointer';
        rowElt.addEventListener('click', (event) => {
            const index = Number.parseInt(event.currentTarget.dataset.index);
            populatechartboad(invoicesData[index]);
            currentInvoice.type = invoicesData[index].typeFacture;
        });
    });
}

// function updateLicenses(licensesData, currency) {
function updateLicenses(licensesData) {
    // console.log(licensesData);
    licensesTableInstance.update({
        rows: licensesData.map(row => {
            return {
                ...row,
                createdAt: `${(new Date(row.createdAt.date)).toLocaleDateString('en-US', {year: 'numeric', month: 'long', day: 'numeric'})}`,
                // amount: `${((row.total + (row.vatAmount ?? 0) + ('number' === typeof row.workforce ? row.workforce : 0)) * getRate(currency)).toFixed(2)} ${currency}`,
                // discount: `${((row.discount ?? 0) * getRate(currency)).toFixed(2)} ${currency}`
            };
        })
    }, { loading: false, hover: true });

    licenseListDatatable.querySelectorAll('tbody > tr').forEach((rowElt) => {
        rowElt.style.cursor = 'pointer';
        rowElt.addEventListener('click', async (event) => {
            const index = Number.parseInt(event.currentTarget.dataset.index);
            await printLicenseReceipt(licensesData[index].id, { title: 'REÇU DE CONTRÔLE TECHNIQUE', itemsContainer: 'horizontalList' });
            // populatechartboad(licensesData[index]);
            // currentInvoice.type = licensesData[index].typeFacture;
        });
    });
}

function displayGrid(container, content, client = {id: null}) {
    const categoriesFragment = content.querySelector('#categories');
    const servicesFragment = content.querySelector('#services');

    if (client['id'] === null) {
        disableCustomerDetailsButtons('customerDetails', 'customerCaution');
    }

    categoriesFragment.innerHTML = '';
    servicesFragment.innerHTML = '';

    for (let i = -2; i < 4; i++) {
        categoriesFragment.innerHTML += `
            <div class="col-md-2">
                <div class="card bg-${i === -2 ? 'success' : (i === -1 ? 'warning' : 'primary')} text-light">
                    <div ${i === -2 ? 'id="hold-invoice" ' : (i === -1 ? 'id="sms-app" ' : '')}class="card-body category" title="${i === -2 ? 'Mettre la facture en pause' : (i === -1 ? 'SMS' : (typeof categories[i] !== 'undefined' ? categories[i]['name'] : ''))}">${i === -2 ? '<i class="fas fa-pause fa-2x text-center text-dark"></i>' : (i === -1 ? '<i class="fas fa-sms fa-2x text-center text-dark"></i>' : (typeof categories[i] !== 'undefined' ? (categories[i]['name'].length > 25 ? categories[i]['name'].slice(0, 25) + '...' : categories[i]['name']) : ''))}</div>
                </div>
            </div>
        `;
    }

    for (let i = 0; i < 24; i++) {
        const serviceExists = typeof services[i] !== 'undefined';
        servicesFragment.innerHTML += `
            <div class="col-md-2">
                <div class="card bg-accent text-light service" data-depot-details-id="${serviceExists && typeof services[i]['id'] !== 'undefined' ? services[i]['id'] : ''}" data-service-id="${serviceExists ? services[i]['serviceId'] : ''}" data-service-type="${serviceExists ? services[i]['type'] : ''}" data-quantity="${serviceExists && typeof services[i]['quantity'] !== 'undefined' ? services[i]['quantity'] : ''}" data-price="${serviceExists ? services[i]['unitPrice'] : ''}">
                    <div class="card-body position-relative">
                        <div class="h6" title="${serviceExists ? services[i]['name'] : ''}">${serviceExists ? (services[i]['name'].length > 20 ? services[i]['name'].slice(0, 20) + '...' : services[i]['name']) : ''}</div>
                        <div>${serviceExists ? (services[i]['unitPrice'] * getVatFactor(services[i]['hasVat']) * getRate(currency)).toFixed(2) + ' ' + currency : ''}</div>
                        <div class="position-absolute badge bg-primary text-light" style="padding: 0.3em;">${serviceExists && typeof services[i]['quantity'] !== 'undefined' ? services[i]['quantity'] : ''}</div>
                    </div>
                </div>
            </div>
        `;
    }

    container.appendChild(document.importNode(content, true));

    document.querySelectorAll('.service').forEach((serv) => {
        serv.addEventListener('click', () => {
            const serviceId = Number.parseInt(serv.dataset.serviceId, 10);
            const service = services.find(s => s.serviceId === serviceId);
            if ('undefined' !== typeof service) {
                currentInvoice = addToCart(service.serviceId, 1, currentInvoice);
                document.getElementById('serviceinputautofocus').value = "";
                document.getElementById('serviceinputautofocus').focus();
            }
        });
    });

    document.querySelector('#hold-invoice').addEventListener('click', () => {
        sell('hold', currentInvoice);
    });

    document.querySelector('#sms-app').addEventListener('click', () => {
        window.open(`${localStorage.getItem('baseUrl')}/smsguichet`);
    });

    document.querySelector('#listfactures').addEventListener('click', () => {
        const invoiceListModal = new mdb.Modal(invoiceList);

        invoiceList.addEventListener('shown.bs.modal', async () => {
            let invoiceDate = (new Date()).toJSON().split('T')[0];
            const savedInvoiceItems = JSON.parse(localStorage.getItem('invoiceItems') ?? '[]');
            let invoices;

            invoiceListDatatable.innerHTML = '';
            invoiceListDatatable.removeAttribute('hidden');

            invoicesTableInstance = new mdb.Datatable(invoiceListDatatable, {
                columns: [
                    { label: 'Date', field: 'dateFact' },
                    { label: 'N° facture', field: 'id' },
                    { label: 'Type', field: 'typeFacture' },
                    { label: 'Client', field: 'nomClient' },
                    { label: 'Montant', field: 'amount' },
                    { label: 'Réduction', field: 'discount' }
                ]
            }, { loading: true });

            invoices = await searchInvoices(savedInvoiceItems, invoiceDate, [{ type: 'object', field: 'dateFact', subfield: 'date', exact: false }]);
            updateInvoices(invoices, currency);
        });

        invoiceListModal.show();
    });

    document.querySelector('#print-receipt').addEventListener('click', () => {
        if (permissions.includes('recu')) {
            const licenseListModal = new mdb.Modal(licenseList);

            licenseList.addEventListener('shown.bs.modal', async () => {
                let licenseDate = (new Date()).toJSON().split('T')[0];
                const savedLicenses = JSON.parse(localStorage.getItem('licenses') ?? '[]');
                let licenses;

                licenseListDatatable.innerHTML = '';
                licenseListDatatable.removeAttribute('hidden');

                licensesTableInstance = new mdb.Datatable(licenseListDatatable, {
                    columns: [
                        { label: 'Date', field: 'createdAt' },
                        { label: 'N° PV', field: 'numeroPv' },
                        { label: 'Immatriculation', field: 'numeroImmatriculation' },
                        { label: 'Client', field: 'nomClient' },
                        // { label: 'Prix du PV', field: 'amount' },
                        // { label: 'Réduction', field: 'discount' }
                    ]
                }, { loading: true });

                licenses = await searchLicenses(savedLicenses, licenseDate, [{ type: 'object', field: 'createdAt', subfield: 'date', exact: false }]);
                // updateLicenses(licenses, currency);
                updateLicenses(licenses);
            });

            licenseListModal.show();

        } else {
            showAlert('Vous n\'êtes pas autorisé d\'imprimer un reçu.', 'warning', false);
        }
    });

    document.querySelector('#print-invoice').addEventListener('click', async () => {
        if (permissions.includes('duplicata')) {
            await printInvoice('DUPLICATA', currentInvoice, { itemsContainer: 'table' });
        } else {
            showAlert('Vous n\'êtes pas autorisé de faire une facture duplicata.', 'warning', false);
        }
    });

    document.querySelector('#proforma').addEventListener('click', () => {
        sell('proforma', currentInvoice);
    });

    document.querySelector('#pay').addEventListener('click', () => {
        sell('sale', currentInvoice);
    });

    document.querySelectorAll('#createCustomer, #customerDetails').forEach((editBtn, idx) => {
        editBtn.addEventListener('click', () => {
            // Save article quantities in the session storage
            document.querySelectorAll('.service').forEach(service => {
                if (Number.parseInt(service.dataset.serviceType, 10) === 2) {
                    sessionStorage.setItem(service.dataset.depotDetailsId, service.dataset.quantity);
                }
            });

            grid.innerHTML = '';
            grid.appendChild(document.importNode(newCustomerForm.content, true));

            document.querySelector('#type-section').innerHTML = `
                <label for="typeClient">Type</label>
                <select name="typeClient" id="typeClient" class="form-control">
                    <option value="physique">Personne physique</option>
                    <option value="morale"${idx === 1 && currentInvoice.client.typeClient === 'morale' ? ' selected' : ''}>Personne morale</option>
                </select>
            `;

            document.querySelector('#typeClient').addEventListener('change', (event) => {
                event.currentTarget.value === 'morale' ? removePhysicalPersonInputs() : setPhysicalPersonInputs();
            });

            if (document.querySelector('#type-section > select').value === 'physique') {
                setPhysicalPersonInputs(idx);
            }

            if (idx === 1) {
                const toExclude = ['id', 'categoryId', 'categoryName', 'totalFactures', 'totalBonus', 'totalCaution'];
                const selects = ['sexe', 'etatCivil', 'employeur'];
                if (currentInvoice.client.typeClient === 'morale') {
                    toExclude.push(selects);
                    removePhysicalPersonInputs();
                }
                document.querySelector('#newCustomerTitle').textContent = `Détails ${currentInvoice.client['sexe'] === 'F' ? 'de la cliente' : 'du client'} ${(null !== currentInvoice.client || 'undefined' !== typeof currentInvoice.client) && 'undefined' !== typeof currentInvoice.client.nomClient ? currentInvoice.client['nomClient'] : ''}`;
                for (const prop in currentInvoice.client) {
                    if (selects.indexOf(prop) > -1 || toExclude.indexOf(prop) === -1) {
                        const propInput = document.querySelector('#' + prop);
                        if (propInput !== null) {
                            propInput.value = currentInvoice.client[prop];
                        } else {
                            currentInvoice.client[prop] = '';
                        }
                    }
                    if (prop === 'categoryId') {
                        document.querySelector('#category').value = currentInvoice.client['categoryId'];
                    }
                }
                if (currentInvoice.client.typeClient === 'physique') {
                    document.querySelectorAll('#employeur > option').forEach(option => {
                        if (option.textContent === currentInvoice.client.employeur) {
                            option.setAttribute('selected', 'selected');
                        }
                    });
                }
                document.querySelectorAll('#category > option').forEach(option => {
                    if (option.value === '0') {
                        document.querySelector('#category').removeChild(option);
                    }
                    if (option.value === currentInvoice.client.category) {
                        option.setAttribute('selected', 'selected');
                    }
                });
                document.querySelector('#addCustomer').textContent = 'Modifier';
            }
            
            document.querySelector('#addCustomer').addEventListener('click', (event) => {
                const isValid = validateForm(event.currentTarget.parentNode, event);

                if (isValid) {
                    const clientForm = document.querySelector('form');
                    const formData = new FormData(clientForm);
                    const headers = new Headers();
                    const spinner = document.querySelector('#spinner');

                    if (idx === 0) {
                        currentInvoice.client = { id: null };
                    }

                    for (const pair of formData.entries()) {
                        Object.assign(currentInvoice.client, {
                            [pair[0]]: pair[1]
                        });
                    }

                    headers.append('Content-Type', 'application/json');
                    headers.append('X-Requested-With', 'XMLHttpRequest');
                    spinner.removeAttribute('hidden');

                    fetch(`${localStorage.getItem('baseUrl')}/clients/${currentInvoice.client.id ?? 'new'}`, {
                        method: 'POST',
                        headers: headers,
                        body: JSON.stringify(currentInvoice.client)
                    }).then(resp => {
                        spinner.setAttribute('hidden', 'hidden');
                        document.querySelectorAll('#client-form .form-control').forEach(formControl => {
                            formControl.classList = 'was-validated form-control';
                        });
                        if (resp.ok) {
                            resp.text().then(responseBody => {
                                const data = JSON.parse(responseBody).data;
                                const verb = currentInvoice.client.id === null ? 'créé' : 'modifié';
                                const form = document.querySelector('#client-form');
                                const isNewClient = null === currentInvoice.client.id;

                                form.querySelectorAll('.error-message').forEach(elt => {
                                    elt.textContent = '';
                                });

                                currentInvoice.client.id = data.id;
                                currentInvoice.client.discountApplicable = data.discountApplicable;
                                currentInvoice.client.totalFactures = isNaN(currentInvoice.client.totalFactures) || 'undefined' === currentInvoice.client.totalFactures || null === currentInvoice.client.totalFactures ? 0 : ('string' === typeof currentInvoice.client.totalFactures ? Number.parseInt(currentInvoice.client.totalFactures, 10) : currentInvoice.client.totalFactures);
                                currentInvoice.client.totalBonus = isNaN(currentInvoice.client.totalBonus) || 'undefined' === currentInvoice.client.totalBonus || null === currentInvoice.client.totalBonus ? 0 : ('string' === typeof currentInvoice.client.totalBonus ? Number.parseFloat(currentInvoice.client.totalBonus) : currentInvoice.client.totalBonus);
                                currentInvoice.client.totalCaution = isNaN(currentInvoice.client.totalCaution) || 'undefined' === currentInvoice.client.totalCaution || null === currentInvoice.client.totalCaution ? 0 : ('string' === typeof currentInvoice.client.totalCaution ? Number.parseFloat(currentInvoice.client.totalCaution) : currentInvoice.client.totalCaution);
                                showAlert(`Client${currentInvoice.client.sexe === 'F' ? 'e' : ''} ${currentInvoice.client.nomClient} ${verb}${currentInvoice.client.sexe === 'F' ? 'e' : ''} avec succès`, 'success', false);
                                document.querySelector('#customerName').textContent = currentInvoice.client.nomClient;
                                document.querySelector('#total-factures').textContent = currentInvoice.client.totalFactures;
                                document.querySelector('#total-bonus').textContent = ((currentInvoice.client.totalBonus ?? 0) * getRate(currency)).toFixed(2);
                                document.querySelector('#total-caution').textContent = ((currentInvoice.client.totalCaution ?? 0) * getRate(currency)).toFixed(2);
                                enableCustomerDetailsButtons('customerDetails', 'customerCaution');
                                // updateTotalElements(total, client.discountApplicable);

                                // Send SMS if new client
                                // if (isNewClient) {
                                //     fetch(`${localStorage.getItem('baseUrl')}/sms/sendtonewclient/${data.id}`, {
                                //         method: 'GET'
                                //     }).then(response => {
                                //         if (response.ok) {
                                //             response.text().then(respBody => {
                                //                 showAlert(JSON.parse(respBody).message, 'success', false);
                                //             });
                                //         } else {
                                //             showAlert('Erreur lors de l\'envoi du message.', 'danger', false);
                                //         }
                                //     });
                                // }
                            });
                        } else {
                            resp.text().then(respBody => {
                                const { message, errors } = JSON.parse(respBody);

                                // if (errors.length > 0) {
                                    const form = document.querySelector('#client-form');
                                    let formInput;

                                    form.querySelectorAll('form-group, form-outline').forEach(formGroup => {
                                        formGroup.classList = formGroup.classList.replace('my-2', 'my-0');
                                    });

                                    form.querySelectorAll('.error-message').forEach(elt => {
                                        elt.textContent = '';
                                    });

                                    for (const propertyPath in errors) {
                                        formInput = form.querySelector('#' + propertyPath);
                                        const errorBlock = form.querySelector('#' + propertyPath + ' + .error-message');
                                        errorBlock.style.fontSize = 'smaller';
                                        errorBlock.innerHTML = '';

                                        errors[propertyPath].forEach(error => {
                                            errorBlock.innerHTML += error.message + '<br>';
                                        });
                                    }

                                    showAlert(message, 'danger', false);
                                // } else {
                                //     showAlert('Une erreur est survenue', 'danger', false);
                                // }
                            });
                        }
                    }).catch(() => {
                        spinner.setAttribute('hidden', 'hidden');
                        showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
                    });
                } else {
                    showAlert('Ce formulaire contient des erreurs', 'danger', false);
                }
            });

            document.querySelector('#close').addEventListener('click', () => {
                grid.innerHTML = '';
                displayGrid(grid, gridContent.content, currentInvoice.client);
                document.querySelectorAll('.service').forEach(service => {
                    if (Number.parseInt(service.dataset.serviceType, 10) === 2) {
                        const qty = sessionStorage.getItem(service.dataset.depotDetailsId);
                        service.dataset.quantity = qty;
                        service.querySelector('.card-body > div:last-child').textContent = qty;
                    }
                });
            });
        });
    });

    document.querySelector('#customerCaution').addEventListener('click', () => {
        cautionDepositModal.show();
    });

    document.querySelector('#toggleNewDepense').addEventListener('click', (e) => {
        if (permissions.includes('depense')) {
            cloture === null ? depenseModal.show() : showAlert('Impossible d\'effectuer une dépense ! Vous avez déjà clôturé la journée.', 'warning', false);
        } else {
            showAlert('Vous n\'êtes pas autorisé de faire une dépense.', 'warning', false);
        }
    });

    document.querySelector('#toggle-paiement-dettes').addEventListener('click', () => {
        if (cloture === null) {
            if (currentInvoice.client.id !== null) {
                const debtPaymentModal = new mdb.Modal(document.getElementById('paiement-dettes'), {});
                debtPaymentModal.show();
            } else {
                showAlert('Veuillez sélectionner un client', 'warning', false);
            }
        } else {
            showAlert('Impossible d\'effectuer l\'opération ! Vous avez déjà clôturé la journée.', 'warning', false);
        }
    });

    document.querySelector('#cloturer').addEventListener('click', () => {
        const spinner = document.querySelector('#spinner');
        spinner.removeAttribute('hidden');
        fetch(`${localStorage.getItem('baseUrl')}/sales/clotures/new`, {
            method: 'GET',
        }).then(resp => {
            if (resp.ok) {
                resp.text().then(responseBody => {
                    clotureElts = JSON.parse(responseBody).data;
                    const depotsCaution = Number.parseFloat(clotureElts.depotsCaution.amount ?? 0);
                    const paiementsParBonus = Number.parseFloat(clotureElts.paiementsParBonus.totalBonus ?? 0) + Number.parseFloat(clotureElts.paiementsParBonus.vatAmount ?? 0);
                    const paiementsParCaution = Number.parseFloat(clotureElts.paiementsParCaution.totalCaution ?? 0) + Number.parseFloat(clotureElts.paiementsParCaution.vatAmount ?? 0);
                    const ventes = Number.parseFloat(clotureElts.ventes.total ?? 0) + Number.parseFloat(clotureElts.ventes.vatAmount ?? 0) + Number.parseFloat(clotureElts.ventes.workforce ?? 0) - Number.parseFloat(clotureElts.ventes.discount ?? 0);
                    const cash = Number.parseFloat(clotureElts.cash.total ?? 0) + Number.parseFloat(clotureElts.cash.vatAmount ?? 0) + Number.parseFloat(clotureElts.cash.workforce ?? 0) - paiementsParBonus - paiementsParCaution - Number.parseFloat(clotureElts.cash.discount ?? 0);
                    const credits = Number.parseFloat(clotureElts.credits.total ?? 0) + Number.parseFloat(clotureElts.credits.vatAmount ?? 0) + Number.parseFloat(clotureElts.credits.workforce ?? 0) - Number.parseFloat(clotureElts.credits.discount ?? 0);
                    const paiementsDettes = Number.parseFloat(clotureElts.paiementsDettes ?? 0);
                    const depenses = Number.parseFloat(clotureElts.depenses ?? 0);
                    spinner.setAttribute('hidden', 'hidden');
                    document.querySelector('#ventes > td:nth-child(2)').textContent = (ventes * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#cash > td:nth-child(2)').textContent = (cash * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#credits > td:nth-child(2)').textContent = (credits * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#ventes-par-bonus > td:nth-child(2)').textContent = (paiementsParBonus * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#ventes-par-caution > td:nth-child(2)').textContent = (paiementsParCaution * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#dettes > td:nth-child(2)').textContent = (paiementsDettes * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#depots-caution > td:nth-child(2)').textContent = (depotsCaution * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#depenses > td:nth-child(2)').textContent = (depenses * getRate(currency)).toFixed(2) + ' ' + currency;
                    document.querySelector('#totalVentes > td:nth-child(2)').textContent = `${((cash + paiementsDettes + depotsCaution - depenses) * getRate(currency)).toFixed(2)} ${currency}`;
                });
            }
        }).catch(() => {
            spinner.setAttribute('hidden', 'hidden');
            showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
        });
    });

    document.querySelectorAll('.confirm-cloture').forEach(elt => {
        cloture !== null ? elt.setAttribute('hidden', 'hidden') : elt.removeAttribute('hidden');
    });

    initDebtPayment('paiement-dettes');
    initDebtPayment('paiement-dettes-employees', '/employes');

    oneTimePayment();
    oneTimePayment('-employees');
}

function updateGrid(servs) {
    services = servs;
    document.querySelector('#grid').innerHTML = '';
    displayGrid(grid, gridContent.content, currentInvoice.client);
}

function validateForm(form, event) {
    let isValid = true;
    if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
        isValid = false;
    }
    form.classList.add('was-validated');
    form.querySelectorAll('#form-control').forEach(formControl => {
        formControl.style.marginBottom = '0';
    });

    return isValid;
}

function emptyInput(input) {
    input.value = '';
}

function addToCart(serviceId, qty, invoice, selectedPrice = null) { // removeEventListener: pending
    const isDiscountApplicable = invoice.client.id !== null && invoice.client.discountApplicable;
    const names = document.querySelectorAll('.table > tbody > tr > td:first-child > .dropdown-toggle');
    const s = findServiceById(serviceId);

    if (qty > 0 && s.quantity <= 0) {
        showAlert('Stock insuffisant', 'warning', false);
    } else if ('undefined' !== typeof s) {
        const serviceExists = serviceExistence(names, (n) => s.name == n.textContent);
        const serviceType = s.type === 1 ? 'service' : 'article';

        if (((serviceType === 'service' || qty > 0) && qty > 0) || qty < 0) {
            const key = s.type === 1 ? s.serviceId : s.id;
            const vatFactor = getVatFactor(s['hasVat']);
            // Verifier si le nom du service existe dans la colonne des noms. Si oui, ajouter la quantite ; sinon ajouter une nouvelle ligne.
            if (!!serviceExists) {
                const qtyElt = serviceExists.parentNode.parentNode.querySelector('td:nth-of-type(2)');
                const priceElt = serviceExists.parentNode.parentNode.querySelector('td:nth-of-type(3)');
                qtyElt.textContent = formatNumber((null === selectedPrice ? Number.parseFloat(qtyElt.textContent) : 0) + qty);
                priceElt.textContent = (null === selectedPrice ? (Number.parseFloat(priceElt.textContent) + qty * s.selectedPrice * vatFactor * getRate(currency)) : qty * selectedPrice * vatFactor * getRate(currency)).toFixed(2);
            } else {
                const cartItem = document.querySelector('#cartItem').content;
                // const quantityElement = cartItem.querySelector('td:nth-of-type(2)');
                cartItem.querySelectorAll('.form-check-input').forEach((input) => {
                    const idArr = input.id.split('-');
                    input.id = `department-${idArr[1]}-service-${s.serviceId}`;
                    input.name = `department-service-${s.serviceId}`;
                });
                cartItem.querySelectorAll('.form-check-label').forEach((label) => {
                    const forArr = label.getAttribute('for').split('-');
                    label.setAttribute('for', `department-${forArr[1]}-service-${s.serviceId}`);
                });
                cartItem.querySelector('tr').dataset.serviceId = serviceId;
                cartItem.querySelector('td > div').textContent = s.name;
                cartItem.querySelector('td:nth-of-type(2)').textContent = formatNumber(qty);
                cartItem.querySelector('td:nth-of-type(3)').textContent = (qty * s.selectedPrice * vatFactor * getRate(currency)).toFixed(2);
                document.querySelector('#cart > tbody').appendChild(document.importNode(cartItem, true));
                document.querySelector('tr:last-of-type > td > .btn-group > button').addEventListener('click', (event) => {
                    const currentQuantity = event.currentTarget.parentNode.parentNode.parentNode.querySelector('td:nth-of-type(2)').textContent;
                    currentInvoice = addToCart(s.serviceId, step(Number.parseFloat(currentQuantity), 1), currentInvoice);
                });
                document.querySelector('tr:last-of-type > td > .btn-group > button:nth-child(2)').addEventListener('click', (event) => {
                    const ancestor = event.currentTarget.parentNode.parentNode.parentNode;
                    currentInvoice = addToCart(s.serviceId, step(Number.parseFloat(ancestor.querySelector('td:nth-of-type(2)').textContent), -1), currentInvoice);
                    if (Number.parseFloat(ancestor.querySelector('td:nth-of-type(2)').textContent) === 0) {
                        document.querySelector('#cart > tbody').removeChild(ancestor);
                    }
                });
                document.querySelector('tr:last-of-type > td > .btn-group > button:last-child').addEventListener('click', (event) => {
                    const ancestor = event.currentTarget.parentNode.parentNode.parentNode;
                    currentInvoice = addToCart(s.serviceId, -1 * Number.parseFloat(ancestor.querySelector('td:nth-of-type(2)').textContent), currentInvoice);
                    document.querySelector('#cart > tbody').removeChild(ancestor);
                });
            }

            if (null === selectedPrice) {
                invoice.total += qty * s.selectedPrice;
            } else {
                const service = findServiceById(serviceId);
                invoice.total += qty * selectedPrice - service.nbUnites * service.selectedPrice;
            }

            // if (isDiscountApplicable && discountables.indexOf(s.serviceId) > -1 && s.selectedPrice === s.unitPrice) {
            if (isDiscountApplicable && discountables.indexOf(s.serviceId) > -1) {
                // if (null === selectedPrice) {
                //     invoice.discount -= qty * (Math.abs(s.unitPrice - s.deflatedPrice));
                // } else {
                    invoice.discount += qty * (Math.abs(s.unitPrice - s.deflatedPrice));
                // }
            }

            // Diminuer ou augmenter la quantite de l'article
            if (serviceType === 'article') {
                const serviceElt = document.querySelector(`#services > div > [data-service-id="${s.serviceId}"]`);

                if (null === selectedPrice || qty !== s.nbUnites) {
                    s.quantity -= qty;
                }

                if (serviceElt !== null) {
                    // console.log(s.quantity);
                    serviceElt.dataset.quantity = s.quantity;
                    serviceElt.querySelector('.card-body > .badge').textContent = formatNumber(s.quantity);
                }
            }

            const salePrice = selectedPrice ?? s.selectedPrice;

            if ('undefined' !== typeof invoice[serviceType + 's'] && invoice[serviceType + 's'].hasOwnProperty(key)) {
                if (null !== selectedPrice) {
                    invoice[serviceType + 's'][key]['nbUnites'] = qty;
                    invoice[serviceType + 's'][key]['selectedPrice'] = selectedPrice;
                } else {
                    invoice[serviceType + 's'][key]['nbUnites'] += qty;
                }
            } else {
                if ('undefined' === typeof invoice[serviceType + 's']) {
                    Object.assign(invoice, {[serviceType + 's']: {}});
                }

                Object.assign(invoice[serviceType + 's'], {
                    [key]: {
                        id: s.id,
                        serviceId: s.serviceId,
                        category: s.category,
                        codeBars: s.codeBars,
                        depotId: s.depotId,
                        depotName: s.depotName,
                        nbUnites: qty,
                        quantity: s.quantity,
                        name: s.name,
                        photo: s.photo,
                        unitPrice: s.unitPrice,
                        deflatedPrice: s.deflatedPrice,
                        wholesalePrice: s.wholesalePrice,
                        selectedPrice: salePrice,
                        type: s.type,
                        bonusApplicable: s.bonusApplicable,
                        hasVat: s.hasVat
                    }
                });
            }

            // Update total elements
            invoice[serviceType + 's'][key]['vatAmount'] = getVatRate(s.hasVat) * invoice[serviceType + 's'][key]['nbUnites'] * salePrice;
            updateTotalElements(invoice.total, invoice.discount);

            if (0 === invoice[serviceType + 's'][key]['nbUnites']) {
                delete invoice[serviceType + 's'][key];
                services = services.map(serv => {
                    if (serv.serviceId === s.serviceId) {
                        serv.selectedPrice = serv.unitPrice;
                    }
                    return serv;
                });
            }
        }
    }

    return invoice;
}

function findServiceById(serviceId) {
    for (const key in currentInvoice.articles) {
        if (Object.hasOwnProperty.call(currentInvoice.articles, key) && serviceId === currentInvoice.articles[key].serviceId) {
            return currentInvoice.articles[key];
        }
    }

    for (const key in currentInvoice.services) {
        if (Object.hasOwnProperty.call(currentInvoice.services, key) && serviceId === currentInvoice.services[key].serviceId) {
            return currentInvoice.services[key];
        }
    }

    return services.find(service => service.serviceId === Number.parseInt(serviceId, 10));
}

window.editQuantity = function(e) {
    const currentTarget = e.currentTarget;
    const serviceId = Number.parseInt(currentTarget.parentNode.dataset.serviceId, 10);
    const quantity = Number.parseFloat(prompt("Quantité"));

    if (!isNaN(quantity) && typeof quantity === 'number') {
        const service = findServiceById(serviceId);
        const oldQty = service.nbUnites;
        const available = service.quantity + oldQty;
        const newQty = (quantity > available ? available : quantity) - oldQty;
        currentInvoice = addToCart(serviceId, newQty, currentInvoice);
    }
};

function updateTtcAmount(totalNet) {
    let totalVatAmount = 0;

    for (const key in currentInvoice.articles) {
        const vatAmount = currentInvoice.articles[key]['vatAmount'];
        if (typeof vatAmount !== 'undefined' && vatAmount > 0) {
            totalVatAmount += vatAmount;
        }
    }

    for (const key in currentInvoice.services) {
        const vatAmount = currentInvoice.services[key]['vatAmount'];
        if (typeof vatAmount !== 'undefined' && vatAmount > 0) {
            totalVatAmount += vatAmount;
        }
    }

    return totalNet + totalVatAmount;
}

function updateTotalElements(total, discountAmount = 0) {
    const discountElt = document.querySelector('#discount');
    const workforceElt = document.querySelector('#workforce');
    const workforceAmount = 'number' === typeof workforcePercent && workforcePercent > 0 ? workforcePercent * total : 0;
    const totalNet = Math.abs(total + workforceAmount - discountAmount);
    document.querySelector('#total').textContent = currency + ' ' + (Math.abs(total) * getRate(currency)).toFixed(2);
    if (null !== discountElt) {
        discountElt.textContent = currency + ' ' + (discountAmount * getRate(currency)).toFixed(2);
    }
    if (null !== workforceElt) {
        workforceElt.textContent = currency + ' ' + (workforceAmount * getRate(currency)).toFixed(2);
    }
    document.querySelector('#net').textContent = currency + ' ' + (totalNet * getRate(currency)).toFixed(2);
    if (ttcAmountElt !== null) {
        ttcAmountElt.textContent = currency + ' ' + (updateTtcAmount(totalNet) * getRate(currency)).toFixed(2);
    }
}

function resetCart() {
    document.querySelectorAll('tr > td > .btn-group > button:last-child').forEach(removeBtn => {
        removeBtn.click();
    });

    document.querySelectorAll('#sale-amount, #sale-workforce').forEach(amountElt => {
        amountElt.value = 0;

        if (amountElt.id === 'workforce') {
            amountElt.parentNode.hidden = 'hidden';
        }
    });

    document.querySelector('#sale-total > span:last-child').textContent = 0;

    updateTotalElements(0);

    document.querySelector('#customerName').textContent = 'Client anonyme';
    document.querySelector('#total-factures').textContent = 0;
    document.querySelector('#total-bonus').textContent = 0.00;
    document.querySelector('#total-caution').textContent = 0.00;

    currentInvoice = { id: null, client: { id: null }, articles: {}, services: {}, total: 0, workforce: 0, discount: 0 };
    licenseId = 0;
    amountPaid = 0;
    amountPaidDebts = 0;
}

function applyDiscount(invoice, discountables) {
    invoice.discount = 0;

    for (const idx in invoice.services) {
        const service = invoice.services[idx];
        if (discountables.indexOf(service.serviceId) > -1) {
            invoice.discount += service.nbUnites * Math.abs(service.unitPrice - service.deflatedPrice);
            invoice.services[idx].selectedPrice = service.deflatedPrice;
        }
    }

    for (const idx in invoice.articles) {
        const article = invoice.articles[idx];
        if (discountables.indexOf(article.serviceId) > -1) {
            invoice.discount += article.nbUnites * Math.abs(article.unitPrice - article.deflatedPrice);
            invoice.articles[idx].selectedPrice = article.deflatedPrice;
        }
    }

    // return invoice;
}

function removeDiscount(invoice) {
    invoice.discount = 0;

    for (const idx in invoice.services) {
        // const service = services.find(s => s.serviceId === invoice.services[idx].serviceId);
        const service = findServiceById(invoice.services[idx].serviceId);
        invoice.services[idx].selectedPrice = service.unitPrice;
    }

    for (const idx in invoice.articles) {
        // const article = services.find(s => s.serviceId === invoice.articles[idx].serviceId);
        const article = findServiceById(invoice.articles[idx].serviceId);
        invoice.articles[idx].selectedPrice = article.unitPrice;
    }

    // return invoice;
}

function proceedToSell(saleType, paymentMode = null, netAmount = null, saleModal = null, saleModalContainer = null, montantPaye = null, isDiscountApplicable = false) {
    let invoice = currentInvoice;
    const saleTotal = (companyHasVat ? updateTtcAmount(invoice.total) : invoice.total) + invoice.workforce - invoice.discount;

    if (!(['proforma', 'hold'].includes(saleType)) && !permissions.includes('credit') && montantPaye < saleTotal) {
        showAlert('Vous n\'êtes pas autorisé de faire une vente à crédit.', 'warning', false);
    } else if (!(['proforma', 'hold'].includes(saleType)) && !permissions.includes('cash') && montantPaye >= saleTotal) {
        showAlert('Vous n\'êtes pas autorisé de faire une vente cash.', 'warning', false);
    } else if (invoice.total > 0) {
        if (!(['proforma', 'hold'].includes(saleType)) && 'undefined' !== typeof netAmount && montantPaye < saleTotal && typeof invoice.client['id'] !== 'number') {
            showAlert('Veuillez sélectionner un client pour continuer.', 'warning', false);
        } else if (paymentMode === 2 && montantPaye > currentInvoice.client.totalBonus) {
            showAlert('Le compte bonus du client est insuffisant pour cette transaction', 'warning', false);
        } else if (paymentMode === 3 && montantPaye > currentInvoice.client.totalCaution) {
            showAlert('Le compte caution du client est insuffisant pour cette transaction', 'warning', false);
        } else {
            const dateTosentElt = document.querySelector('#dateretraitinput');
            let dateTosent = '';
            let payload;
            const vatRate = typeof maison.vatRate === 'number' ? maison.vatRate : 0;
            const spinner = document.querySelector('#spinner');
            const bankAccount = paymentMode === 4 ? Number.parseInt(document.querySelector('#bankaccount').value, 10) : null;

            if (dateTosentElt !== null) {
                dateTosent = dateTosentElt.value;
            }

            if ('' === dateTosent) {
                // echeance de 7 jours par defaut
                dateTosent = (new Date(Date.now() + 604800000)).toJSON();
            }

            payload = { sourceInvoiceId: invoice?.id, client: invoice.client['id'], saleType, paymentMode, bankAccount, amountPaid: montantPaye, total: invoice.total, workforce: (invoice.workforce === 0 && 'number' === typeof workforcePercent && workforcePercent > 0 ? workforcePercent * invoice.total : invoice.workforce), workforcePercent, discount: invoice.discount, details: invoice, licenseId, date: dateTosent, vatRate };
            Object.assign(payload, { deptProdArr: departmentProductArr });
            spinner.removeAttribute('hidden');

            fetch(`${localStorage.getItem('baseUrl')}/sales/new`, {
                method: 'POST',
                headers: new Headers({ 'Content-Type': 'application/json' }),
                body: JSON.stringify(payload)
            }).then(resp => {
                const saleButton = saleModalContainer?.querySelector('.modal-footer > button:nth-child(2)');

                if (resp.ok) {
                    resp.text().then(respBody => {
                        const parsedBody = JSON.parse(respBody);
                        const totalFacturesElt = document.querySelector('#total-factures');
                        const clientId = parsedBody.clientId;

                        sessionStorage.setItem('invoiceId', parsedBody.invoiceId);
                        invoice.id = parsedBody.invoiceId;
                        invoice.type = saleType;

                        if (['cash', 'credit', 'caution'].indexOf(saleType) > -1) {
                            if (clientId !== null) {
                                const totalBonusElt = document.querySelector('#total-bonus');
                                const totalCautionElt = document.querySelector('#total-caution');

                                currentInvoice.client.totalBonus = isNaN(currentInvoice.client.totalBonus) || 'undefined' === currentInvoice.client.totalBonus ? 0 : ('string' === typeof currentInvoice.client.totalBonus ? Number.parseFloat(currentInvoice.client.totalBonus) : currentInvoice.client.totalBonus);
                                currentInvoice.client.totalCaution = isNaN(currentInvoice.client.totalCaution) || 'undefined' === currentInvoice.client.totalCaution ? 0 : ('string' === typeof currentInvoice.client.totalCaution ? Number.parseFloat(currentInvoice.client.totalCaution) : currentInvoice.client.totalCaution);
                                totalBonusElt.textContent = ((currentInvoice.client.totalBonus ?? 0) * getRate(currency)).toFixed(2);
                                totalCautionElt.textContent = ((currentInvoice.client.totalCaution ?? 0) * getRate(currency)).toFixed(2);

                                spinner.setAttribute('hidden', 'hidden');

                                const bonuses = parsedBody.bonuses;
                                const totalBonus = bonuses.length > 0 ? bonuses.reduce((accu, next) => accu + next, 0) : 0;
                                let suffixe = '';

                                if (totalBonus > 0) {
                                    suffixe = ` Le client vient de gagner ${(totalBonus * getRate(currency)).toFixed(2)} ${currency} en bonus.`;
                                    currentInvoice.client.totalBonus += totalBonus;
                                    totalBonusElt.textContent = (Number.parseFloat(totalBonusElt.textContent) + (totalBonus * getRate(currency))).toFixed(2);
                                }

                                showAlert(`Vente ${saleType} effectuée avec succès !${suffixe}`, 'success', false);

                            } else {
                                spinner.setAttribute('hidden', 'hidden');
                                showAlert(`Vente ${saleType} effectuée avec succès !`, 'success', false);
                            }
                        } else if (saleType === 'proforma') {
                            spinner.setAttribute('hidden', 'hidden');
                            showAlert('Facture proforma enregistrée', 'success', false);
                        } else if (saleType === 'hold') {
                            spinner.setAttribute('hidden', 'hidden');
                            showAlert('Facture mise en pause', 'success', false);
                        }

                        if (clientId !== null) {
                            totalFacturesElt.textContent = Number.parseInt(totalFacturesElt.textContent, 10) + 1;
                        }

                        // reset the selected price for all services
                        services = services.map(service => Object.assign(service, {selectedPrice: service.unitPrice}));
                    });

                } else {
                    resp.text().then(responseBody => {
                        showAlert(JSON.parse(responseBody).message, 'danger', false);
                    });
                }

                departmentProductArr = [];

                if (null !== saleButton && !(['proforma', 'hold'].includes(saleType))) {
                    saleButton.removeEventListener('click', proceedToSell, false);
                }
            }).catch(() => {
                spinner.setAttribute('hidden', 'hidden');
                showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
            });

            if (!(['proforma', 'hold'].includes(saleType))) {
                saleModal.hide();
            }

            sessionStorage.setItem('invoice', JSON.stringify(payload));
            resetCart();

            if (null !== saleModal) {
                saleModal.hide();
            }

            window.location.reload();
        }
    }
}

function sell(type, invoice) {
    if (cloture === null) {

        if (!permissions.includes('proforma') && type === 'proforma') {
            showAlert('Vous n\'êtes pas autorisé de faire une facture proforma.', 'warning', false);
        } else if (invoice.total > 0) {
            let montantPaye = null;
            let saleType = type;
            let paymentMode = 1;
            let isDiscountApplicable = false;
            let netAmount = invoice.total - invoice.discount;
            let ttcAmount = 0;

            invoice.workforce = 0;

            for (const key in invoice.articles) {
                const article = invoice.articles[key];
                ttcAmount += article.selectedPrice * article.nbUnites + article.vatAmount;
            }

            for (const key in invoice.services) {
                const service = invoice.services[key];
                ttcAmount += service.selectedPrice * service.nbUnites + service.vatAmount;
            }

            if (saleType === 'sale') {
                const saleModalElt = document.querySelector('#sale-modal');
                const saleModal = new mdb.Modal(saleModalElt);
                let paymentModeSelect = saleModalElt.querySelector('#payment-mode');
                let saleModalContainer;
                let amountElt;
                let saleTotalElt;

                if (!isNaN(currentInvoice.client.totalBonus) && currentInvoice.client.totalBonus >= netAmount + invoice.workforce || !isNaN(currentInvoice.client.totalCaution) && currentInvoice.client.totalCaution >= netAmount + invoice.workforce || bankAccounts.length > 0) {
                    paymentModeSelect.removeAttribute('disabled');
                    paymentModeSelect.addEventListener('change', (e) => {
                        paymentMode = Number.parseFloat(e.currentTarget.value);
                    });

                    if (isNaN(currentInvoice.client.totalBonus) || currentInvoice.client.totalBonus < netAmount) {
                        paymentModeSelect.querySelector('option:nth-of-type(2)').setAttribute('hidden', 'hidden');
                    }

                    if (isNaN(currentInvoice.client.totalCaution) || currentInvoice.client.totalCaution < netAmount) {
                        paymentModeSelect.querySelector('option:nth-of-type(3)').setAttribute('hidden', 'hidden');
                    }
                }

                isDiscountApplicable = currentInvoice.client.id !== null && currentInvoice.client.discountApplicable && [1, 3].includes(paymentMode);

                saleModalElt.addEventListener('shown.bs.modal', (e) => {
                    saleModalContainer = e.currentTarget;
                    amountElt = saleModalContainer.querySelector('#sale-amount');
                    saleTotalElt = saleModalContainer.querySelector('#sale-total > span:nth-child(2)');
                    netAmount = companyHasVat ? ttcAmount : netAmount;
                    montantPaye = netAmount;
                    amountElt.dataset.netAmount = netAmount;
                    amountElt.value = (netAmount * getRate(currency)).toFixed(2);
                    // montantPaye = companyHasVat ? ttcAmount : netAmount;
                    saleTotalElt.dataset.montantPaye = netAmount;
                    saleTotalElt.textContent = (netAmount * getRate(currency)).toFixed(2);

                    // if (typeof saleTotalTtcElt !== 'undefined') {
                    //     console.log(ttcAmount);
                    //     saleTotalTtcElt.textContent = (ttcAmount * getRate(currency)).toFixed(2);
                    // }

                    if ('number' === typeof workforcePercent && workforcePercent > 0) {
                        const workforceElt = saleModalContainer.querySelector('#sale-workforce');
                        const workforceData = null === workforcePercent ? 0 : netAmount * workforcePercent;
                        workforceElt.dataset.workforce = workforceData;
                        workforceElt.value = workforceData * getRate(currency);

                        const updateSaleTotal = (currentTarget) => {
                            if (!Number.parseFloat(workforceElt.value)) {
                                workforceElt.dataset.workforce = 0;
                                workforceElt.value = 0;
                            }

                            if ('undefined' !== typeof currentTarget) {
                                if (currentTarget.id === 'sale-workforce') {
                                    workforceElt.dataset.netAmount = workforceElt.value / getRate(currency);
                                    invoice.workforce = Number.parseFloat(workforceElt.dataset.workforce);
                                } else {
                                    amountElt.dataset.netAmount = amountElt.value / getRate(currency);
                                    netAmount = Number.parseFloat(amountElt.dataset.netAmount);
                                }
                            }

                            montantPaye = netAmount + Number.parseFloat(invoice.workforce);
                            saleTotalElt.dataset.montantPaye = montantPaye;
                            saleTotalElt.textContent = (montantPaye * getRate(currency)).toFixed(2);

                            if (!isNaN(currentInvoice.client.totalBonus) || !isNaN(currentInvoice.client.totalCaution)) {
                                if (montantPaye <= currentInvoice.client.totalBonus || montantPaye <= currentInvoice.client.totalCaution || bankAccounts.length > 0) {
                                    paymentModeSelect.removeAttribute('disabled');
                                } else {
                                    paymentMode = 1;
                                    paymentModeSelect.setAttribute('disabled', 'disabled');
                                }
                            }
                        };

                        invoice.workforce = ((workforcePercent ?? 0.2) * netAmount).toFixed(2);

                        if (null !== workforceElt) {
                            workforceElt.dataset.workforce = invoice.workforce;
                            workforceElt.value = invoice.workforce * getRate(currency);
                        }

                        updateSaleTotal();

                        if (null !== workforceElt) {
                            workforceElt.parentNode.removeAttribute('hidden');
                        }
    
                        [amountElt, workforceElt].forEach(elt => {
                            elt.addEventListener('blur', (e) => {
                                const currentTarget = e.currentTarget;
                                updateSaleTotal(currentTarget);
                            });
                            elt.addEventListener('keypress', (e) => {
                                const currentTarget = e.currentTarget;
                                setTimeout(() => {
                                    updateSaleTotal(currentTarget);
                                }, 10);
                            });
                        });
                    } else {
                        const updateSaleTotal = (currentTarget) => {
                            if ('undefined' !== typeof currentTarget) {
                                amountElt.dataset.netAmount = amountElt.value / getRate(currency);
                                netAmount = Number.parseFloat(amountElt.dataset.netAmount);
                            }

                            montantPaye = netAmount;
                            saleTotalElt.dataset.montantPaye = montantPaye;
                            saleTotalElt.textContent = (montantPaye * getRate(currency)).toFixed(2);

                            if (!isNaN(currentInvoice.client.totalBonus) || !isNaN(currentInvoice.client.totalCaution)) {
                                if (montantPaye <= currentInvoice.client.totalBonus || montantPaye <= currentInvoice.client.totalCaution || bankAccounts.length > 0) {
                                    paymentModeSelect.removeAttribute('disabled');
                                } else {
                                    paymentMode = 1;
                                    paymentModeSelect.setAttribute('disabled', 'disabled');
                                }
                            }
                        };

                        amountElt.addEventListener('blur', (e) => {
                            const currentTarget = e.currentTarget;
                            updateSaleTotal(currentTarget);
                        });
                        amountElt.addEventListener('keypress', (e) => {
                            const currentTarget = e.currentTarget;
                            setTimeout(() => {
                                updateSaleTotal(currentTarget);
                            }, 10);
                        });
                    }

                    paymentModeSelect.addEventListener('change', () => {
                        const bankAccountElt = document.querySelector('#bankaccount');
                        [2, 3].includes(paymentMode) ? amountElt.setAttribute('disabled', 'disabled') : amountElt.removeAttribute('disabled');
                        if (paymentMode === 4) {
                            bankAccountElt.removeAttribute('disabled');
                        } else {
                            bankAccountElt.value = '';
                            bankAccountElt.setAttribute('disabled', 'disabled');
                        }
                        if ('number' === typeof workforcePercent && workforcePercent > 0) {
                            [2, 3].includes(paymentMode) ? workforceElt.setAttribute('disabled', 'disabled') : workforceElt.removeAttribute('disabled');
                        }
                    });

                    saleModalContainer.querySelector('#sale-modal-close').addEventListener('click', () => {
                        resetCart();
                        saleModal.hide();
                        window.location.reload();
                    });

                    sessionStorage.setItem('invoice', JSON.stringify(invoice));

                    saleModalContainer.querySelector('.modal-footer > button:first-child').addEventListener('click', () => {
                        let ttcAmount = 0;
                        currentInvoice = JSON.parse(sessionStorage.getItem('invoice'));
                        sessionStorage.removeItem('invoice');

                        if (companyHasVat) {
                            ttcAmount = updateTtcAmount(invoice.total);
                        }

                        saleType = montantPaye < (ttcAmount > 0 ? ttcAmount : invoice.total) + invoice.workforce - invoice.discount ? 'credit' : 'cash';
                        // console.log(departmentProductArr);
                        proceedToSell(saleType, paymentMode, netAmount, saleModal, saleModalContainer, montantPaye, isDiscountApplicable);
                    });
                });

                saleModal.show();

            } else {
                if ('number' === typeof workforcePercent && workforcePercent > 0) {
                    if (saleType === 'proforma') {
                        const proformaModalElt = document.querySelector('#proforma-modal');
                        const proformaModal = new mdb.Modal(proformaModalElt);
                        const workforceValue = (workforcePercent ?? 0) * currentInvoice.total;

                        proformaModalElt.addEventListener('shown.bs.modal', (e) => {
                            const proformaModalContainer = e.currentTarget;

                            proformaModalElt.querySelector('#proforma-workforce-input').value = (getRate(currency) * workforceValue).toFixed(2);
                            proformaModalElt.querySelector('#discount-proforma').textContent = (getRate(currency) * currentInvoice.discount).toFixed(2);
                            proformaModalElt.querySelector('#total-proforma').textContent = (getRate(currency) * currentInvoice.total).toFixed(2);
                            proformaModalElt.querySelector('#net-proforma').textContent = (getRate(currency) * (workforceValue + currentInvoice.total - currentInvoice.discount)).toFixed(2);

                            proformaModalContainer.querySelector('#proforma-modal-close').addEventListener('click', () => {
                                resetCart();
                                proformaModal.hide();
                                window.location.reload();
                            });

                            sessionStorage.setItem('invoice', JSON.stringify(invoice));

                            proformaModalContainer.querySelector('.modal-footer > button').addEventListener('click', () => {
                                currentInvoice = JSON.parse(sessionStorage.getItem('invoice'));
                                sessionStorage.removeItem('invoice');
                                proformaModal.hide();
                                // sessionStorage.setItem('facture', JSON.stringify(currentInvoice));
                                proceedToSell('proforma');
                            });
                        });
                        proformaModal.show();
                    } else {
                        proceedToSell('hold');
                    }

                } else {
                    proceedToSell(saleType);
                }
            }
        }

    } else {
        showAlert('Vous avez déjà clôturé la journée', 'warning', false);
    }
}

window.createDepense = function(event) {
    const parentNode = event.currentTarget.parentNode.parentNode;
    const spinner = document.querySelector('#spinner');
    spinner.removeAttribute('hidden');

    fetch(`${localStorage.getItem('baseUrl')}/sales/clotures/new`, {
        method: 'GET',
    }).then(resp => {
        if (resp.ok) {
            resp.text().then(responseBody => {
                clotureElts = JSON.parse(responseBody).data;
                const total = typeof clotureElts.cash.total === 'string' ? Number.parseFloat(clotureElts.cash.total) : (typeof clotureElts.cash.total === 'number' ? clotureElts.cash.total : 0);
                const paiementsDettes = typeof clotureElts.paiementsDettes === 'string' ? Number.parseFloat(clotureElts.paiementsDettes) : (typeof clotureElts.paiementsDettes === 'number' ? clotureElts.paiementsDettes : 0);
                const depotsCautions = typeof clotureElts.depotsCaution.amount === 'string' ? Number.parseFloat(clotureElts.depotsCaution.amount) : (typeof clotureElts.depotsCaution.amount === 'number' ? clotureElts.depotsCaution.amount : 0);
                const amount = Number.parseFloat(parentNode.querySelector('#amount').value) / getRate(currency);

                if (total + paiementsDettes + depotsCautions > amount) {
                    const formData = new FormData(parentNode.querySelector('form'));
                    const headers = new Headers({ 'X-Requested-With': 'XMLHttpRequest' });
                    const payload = {};
                    for (const pair of formData.entries()) {
                        const value = pair[0] === 'amount' ? Number.parseFloat(pair[1]) / getRate(currency) : (pair[0] === 'type_depense' ? Number.parseInt(pair[1], 10) : pair[1]);
                        Object.assign(payload, {[pair[0]]: value});
                    }
                    Object.assign(payload, {amount: Number.parseFloat(payload['amount']), typeDepense: Number.parseInt(payload['typeDepense'])});
                    fetch(`${localStorage.getItem('baseUrl')}/depenses/new`, {
                        method: 'POST',
                        headers: headers,
                        body: JSON.stringify(payload)
                    }).then(resp => {
                        if (resp.ok) {
                            resp.text().then(data => {
                                spinner.setAttribute('hidden', 'hidden');
                                showAlert(JSON.parse(data), 'success', false);
                            });
                        }
                    }).catch(() => {
                        spinner.setAttribute('hidden', 'hidden');
                        showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
                    });
                } else {
                    spinner.setAttribute('hidden', 'hidden');
                    showAlert('Vous ne pouvez pas dépenser un montant supérieur au solde de votre caisse.', 'warning', false);
                }
            });
        }
    }).catch(() => {
        spinner.setAttribute('hidden', 'hidden');
        showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
    });
};

window.payerDettes = function(employes = '') {
    const spinnerElt = document.getElementById('spinner');

    document.querySelector('#confirm-print-receipt .modal-body > div:last-child > button:first-child').addEventListener('click', () => {
        printReceiptModal.hide();
    });

    if (amountPaidDebts > 0) {
        fetch(`${localStorage.getItem('baseUrl')}/dettes/${currentInvoice.client.id}/paiement${employes === '' ? '' : '/employees'}?amount=${amountPaidDebts}`, {
            method: 'GET'
        }).then(resp => {
            if (resp.ok) {
                resp.text().then(data => {
                    // spinnerElt.setAttribute('hidden', 'hidden');
                    document.querySelector('#confirm-print-receipt .modal-body > div:nth-child(2) > div:last-child').textContent = (amountPaidDebts * getRate(currency)).toFixed(2);
                    document.querySelector('#confirm-print-receipt .modal-body > div:nth-child(3) > div:last-child').textContent = ((amountDueSold - amountPaidDebts) * getRate(currency)).toFixed(2);
                    printReceiptModal.show();
                });
            }
        }).catch(() => {
            showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
        });

    } else if (selectedDebts.length > 0) {
        const headers = new Headers({
            'Content-Type': 'application/json'
        });
        const debts = selectedDebts.map(debt => {
            return {
                id: debt.id,
                amountPaid: Number.parseFloat(document.querySelector(`#debts-table${employes} tbody > tr:nth-child(${debt.rowIndex + 1}) > td:nth-child(6)`).textContent) / getRate(currency)
            };
        });

        fetch(`${localStorage.getItem('baseUrl')}/dettes/${currentInvoice.client.id}/paiement`, {
            headers: headers,
            method: 'POST',
            body: JSON.stringify(debts)
        }).then(resp => {
            if (resp.ok) {
                resp.text().then(data => {
                    spinnerElt.setAttribute('hidden', 'hidden');
                    amountPaidDebts = debts.reduce((accu, debt) => accu + debt.amountPaid, 0);
                    document.querySelector('#confirm-print-receipt .modal-body > div:nth-child(2) > div:last-child').textContent = (amountPaidDebts * getRate(currency)).toFixed(2);
                    document.querySelector('#confirm-print-receipt .modal-body > div:nth-child(3) > div:last-child').textContent = ((amountDueSold - amountPaidDebts) * getRate(currency)).toFixed(2);
                    printReceiptModal.show();
                });
            }
        }).catch(() => {
            spinner.setAttribute('hidden', 'hidden');
            showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
        });
    }

    spinnerElt.removeAttribute('hidden');
};

function initDebtPayment(modalId, urlFragment = '') {
    document.getElementById(modalId).addEventListener('shown.bs.modal', () => {
        const datatable = document.querySelector(`#${modalId} .modal-body > .datatable`);
        const payForEmployeesBtn = document.querySelector('#paiement-dettes .modal-footer button:first-child');
        let isEnterprise;
        const columns = [
            { label: 'Date d\'octroi', field: 'dateOctroi' },
            { label: 'Echéance', field: 'echeance' },
            { label: 'Crédit', field: 'amount' },
            { label: 'Déjà payé', field: 'paid' },
            { label: 'A payer', field: 'sold' },
            { label: 'Solde', field: 'remainder' },
            { label: 'ID', field: 'id', sort: false }
        ];

        if (!!urlFragment) {
            columns.push({ label: 'Employé', field: 'nomClient' });
        }

        datatable.removeAttribute('hidden');
        datatable.innerHTML = '';
        datatable.dataset.maxHeight = 400;

        const debtsTableInstance = new mdb.Datatable(datatable, {
            columns: columns
        }, { loading: true });

        if (currentInvoice.client.typeClient === 'morale') {
            payForEmployeesBtn.removeAttribute('hidden');
            isEnterprise = true;
        } else {
            payForEmployeesBtn.setAttribute('hidden', 'hidden');
            isEnterprise = false;
        }

        document.querySelector('#paiementDettesModalLabel > span').textContent = currentInvoice.client.nomClient;

        fetch(`${localStorage.getItem('baseUrl')}/dettes/${currentInvoice.client.id}${urlFragment}`, {
            method: 'GET'
        }).then(resp => {
            if (resp.ok) {
                resp.text().then(responseBody => {
                    const body = JSON.parse(responseBody);
                    const dettes = body.data.debts;
                    const total = dettes.reduce((accu, next) => accu + next.sold, 0);

                    const setDynamicParts = () => {
                        amountDueSold = total + (isEnterprise && urlFragment === '' ? (!!body.data.totalEmployees ? Number.parseFloat(body.data.totalEmployees) : 0) : 0);
                        document.querySelector(`#${modalId} .modal-footer > div:first-child > div > span:nth-child(2)`).textContent = (amountDueSold * getRate(currency)).toFixed(2);
    
                        document.querySelectorAll('#paiement-dettes .modal-footer > div:first-child > div > span:not(:first-child):not(:nth-child(2))').forEach(span => {
                            isEnterprise ? span.removeAttribute('hidden') : span.setAttribute('hidden', 'hidden');
                        });
                        document.querySelector('#enterprise-debts').textContent = ((isEnterprise ? total : 0) * getRate(currency)).toFixed(2);
                        document.querySelector('#employees-debts').textContent = ((isEnterprise ? (!!body.data.totalEmployees ? Number.parseFloat(body.data.totalEmployees) : 0) : 0) * getRate(currency)).toFixed(2);
    
                        datatable.querySelectorAll('tbody > tr > td:nth-child(8), thead > tr > th:nth-child(8)').forEach(idElt => {
                            idElt.setAttribute('hidden', 'hidden');
                        });
    
                        datatable.querySelectorAll('tbody > tr').forEach(rowElt => {
                            rowElt.style.cursor = 'pointer';
                        });
    
                        datatable.querySelectorAll('tbody > tr > td:nth-child(6)').forEach(elt => {
                            const amountDue = Number.parseFloat(elt.textContent);
                            // Number.parseFloat(elt.parentNode.querySelector('td:nth-child(5)').textContent)
                            elt.setAttribute('contenteditable', true);
                            elt.addEventListener('keyup', () => {
                                const eltContent = Number.parseFloat(elt.textContent);
                                const pay = isNaN(eltContent) ? 0 : eltContent;
                                const diff = amountDue - pay;
                                if (pay >= 0 && diff >= 0) {
                                    elt.parentNode.querySelector('td:nth-child(7)').textContent = diff.toFixed(2);
                                } else {
                                    elt.blur();
                                    elt.textContent = amountDue.toFixed(2);
                                    elt.parentNode.querySelector('td:nth-child(7)').textContent = (0).toFixed(2);
                                }
                            });
                        });
    
                        datatable.addEventListener('selectRows.mdb.datatable', e => {
                            const payBtn = document.getElementById('payer-dettes' + (modalId === 'paiement-dettes' ? '' : '-employees'));
                            e.selectedIndexes.length > 0 ? payBtn.removeAttribute('disabled') : payBtn.setAttribute('disabled', 'disabled');
                            selectedDebts = e.selectedRows;
                            amountPaidDebts = 0;
                        });
                    };

                    datatable.addEventListener('render.mdb.datatable', setDynamicParts);

                    debtsTableInstance.update({
                        rows: dettes.map(row => {
                            const newRow = {
                                ...row,
                                dateOctroi: `${(new Date(row.dateOctroi.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'short', day: 'numeric'})}`,
                                echeance: `${(new Date(row.echeance.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'short', day: 'numeric'})}`,
                                amount: `${(row.amount * getRate(currency)).toFixed(2)}`,
                                paid: `${((row.amount - row.sold) * getRate(currency)).toFixed(2)}`,
                                sold: `${(row.sold * getRate(currency)).toFixed(2)}`,
                                remainder: `${(0).toFixed(2)}`,
                            };

                            if (!!urlFragment) {
                                Object.assign(newRow, { nomClient: row.nomClient });
                            }

                            return newRow;
                        }),
                    }, { loading: false, hover: true });
                });
            }
        }).catch(() => {
            showAlert('Vérifiez votre connexion ! Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
        });

        document.getElementById((modalId.indexOf('employees') === -1 ? '' : 'employees-') + 'debt-search-input').addEventListener('input', (e) => {
            debtsTableInstance.search(e.target.value);
        });
    });
}

function oneTimePayment(suffixe = '') {
    document.getElementById(`debt-amount${suffixe}`).addEventListener('keyup', (event) => {
        const payBtn = document.getElementById(`payer-dettes${suffixe}`);
        const checkboxes = document.querySelectorAll(`#paiement-dettes${suffixe} .modal-body > .datatable .form-check-input`);
        const inputValue = event.currentTarget.value;

        if (inputValue.trim() !== '') {
            amountPaidDebts = Number.parseFloat(inputValue) / getRate(currency);
        }

        if (amountPaidDebts > 0) {
            payBtn.removeAttribute('disabled');
            checkboxes.forEach(checkbox => {
                checkbox.checked = false;
                checkbox.setAttribute('disabled', 'disabled');
            });
        } else {
            payBtn.setAttribute('disabled', 'disabled');
            checkboxes.forEach(checkbox => {
                checkbox.removeAttribute('disabled');
            });
        }
    });
}

// function printInvoice(printType, permissions, facture = null) {
async function printInvoice(printType, facture = null, options = {}) {
    const spinner = document.querySelector('#spinner');
    spinner.removeAttribute('hidden');
    const invoice = facture ?? currentInvoice;
    const url = `${localStorage.getItem('baseUrl')}/invoices/${invoice.id}/export-pdf/${invoiceSettings.paperFormat.key}?printType=${printType}&itemsContainer=${options.itemsContainer}`;
    const blob = await getFileFromServer(url);
    spinner.setAttribute('hidden', 'hidden');
    printJS({ printable: URL.createObjectURL(blob), type: 'pdf' });

    // if (null !== invoice.id) {
    //     const spinner = document.querySelector('#spinner');
    //     const invoiceTemplate = document.querySelector('#invoice-template');
    //     const invoiceTableBody = document.querySelector('#invoice-table-body');
    //     const invoiceFooter = document.getElementById('invoice-footer');
    //     const invoiceTotals = document.getElementById('invoice-totals');
    //     let servicesForBonus = [];
    //     let dateRetrait;
    //     const headers = new Headers({'Content-Type': 'application/json'});   
    //     const dateTosentElt = document.querySelector('#dateretraitinput');
    //     let dateTosent = '';

    //     if (dateTosentElt !== null) {
    //         dateTosent = dateTosentElt.value;
    //     }

    //     fetch(`${localStorage.getItem('baseUrl')}/facturedateretrait`, {
    //         method: 'POST',
    //         headers: headers,
    //         body: JSON.stringify({ factureId: invoice.id, date: dateTosent })
    //     }).then(resp => {
    //         if (resp.ok) {
    //             resp.text().then(responseData => {
    //                 const data = JSON.parse(responseData);
    //                 const dbInvoice = data.invoice;
    //                 const client = data.client;
    //                 const marque = data.marque;
    //                 const typeOuModele = data.typeOuModele;
    //                 const numeroImmatriculation = data.numeroImmatriculation;
    //                 // const kilometrage = data.kilometrage;
    //                 let invoiceNet;
    //                 let invoiceTtc;
    //                 const fullySpelledOut = new FullySpelledOut();

    //                 invoice.id = dbInvoice.id;
    //                 invoice.total = dbInvoice.total;
    //                 invoice.discount = dbInvoice.discount;
    //                 invoice.amountPaid = dbInvoice.amountPaid;
    //                 invoice.workforce = dbInvoice.workforce;
    //                 invoice.workforcePercent = dbInvoice.workforcePercent;
    //                 invoice.type = dbInvoice.type;
    //                 invoice.paymentMode = dbInvoice.paymentMode;
    //                 invoice.date = dbInvoice.date;
    //                 // sessionStorage.setItem('invoicePrint', invoice);
    //                 // JSON.parse(sessionStorage.getItem('invoicePrint'))

    //                 invoiceNet = invoice.total + invoice.workforce - (client.id !== null ? invoice.discount : 0);
    //                 invoiceTtc = invoice.workforce - (client.id !== null ? invoice.discount : 0);
    //                 dateRetrait = data.dateRetrait;
    //                 licenseId = dbInvoice.licenseId ?? 0;

    //                 if (permissions.includes('facture-controle-technique')) {
    //                     document.querySelector('#invoice-client').innerHTML =
    //                         `
    //                             <div class="w-100 d-flex justify-content-between text-left border-dark">
    //                                 <div class="px-1 w-50">
    //                                     <div class="w-100 mt-1 bg-yellow font-weight-bold">${maison['nomSociete'] ?? ''}</div>
    //                                     <div class="w-100 text-ellipsis word-break">${maison['adressePhysique']?.slice(0, 46)}</div>
    //                                     <div class="w-100">N° Impôt :&nbsp;${maison['numImpot'] ?? ''}&nbsp;/&nbsp;Id.Nat. :&nbsp;${maison['idNationnal'] ?? ''}</div>
    //                                     <div class="w-100">RCCM :&nbsp;${maison['registreCommerce'] ?? ''}</div>
    //                                     <div class="w-100">Téléphone :&nbsp;${maison['telephone'] ?? ''}</div>
    //                                     <div class="w-100 mb-1">E-mail :&nbsp;${maison['mail'] ?? ''}</div>
    //                                 </div>
    //                                 <div class="px-1 w-50 border-left">
    //                                     <div class="w-100 mt-1 bg-yellow">
    //                                         <span>À&nbsp;:&nbsp;</span>
    //                                         <span>${client.nomClient ?? ''}</span>
    //                                     </div>
    //                                     <div>
    //                                         <span>Adresse&nbsp;:&nbsp;</span>
    //                                         <span>${client.adressePhys ?? ''}</span>
    //                                     </div>
    //                                     <div>
    //                                         <span>Plaque&nbsp;:&nbsp;</span>
    //                                         <span>${numeroImmatriculation ?? ''}</span>
    //                                     </div>
    //                                     <div>
    //                                         <span>Véhicule&nbsp;:&nbsp;</span>
    //                                         <span>${marque ?? ''} ${typeOuModele ?? ''}</span>
    //                                     </div>
    //                                     <div>
    //                                         <span>Téléphone&nbsp;:&nbsp;</span>
    //                                         <span>${client.telephone ?? ''}</span>
    //                                     </div>
    //                                     <div class="mb-1">
    //                                         <span>Code&nbsp;client&nbsp;:&nbsp;</span>
    //                                         <span>${client.id ?? ''}</span>
    //                                     </div>
    //                                 </div>
    //                             </div>
    //                         `
    //                     ;
    //                 } else {
    //                     document.querySelector('#invoice-client').innerHTML = `${client.id === null ? '' : '<b>Client : ' + client.nomClient}</b>`;
    //                 }

    //                 invoiceTableBody.innerHTML = '';

    //                 for (const key in invoice.articles) {
    //                     const selectedPrice = invoice.articles[key].selectedPrice;
    //                     const totalPrice = Number.parseFloat(invoice.articles[key].nbUnites) * selectedPrice;
    //                     const localPrice = (selectedPrice * getVatFactor(invoice.articles[key]['hasVat'])) * getRate(currency);
    //                     const localTotalPrice = (totalPrice + (invoice.articles[key]['vatAmount'] ?? 0)) * getRate(currency);
    //                     invoiceTtc += localTotalPrice;
    //                     invoiceTableBody.innerHTML += `
    //                         <tr>
    //                             <td class="${permissions.includes('facture-controle-technique') ? 'border-right px-1' : ''}">${invoice.articles[key].name}</td>
    //                             <td class="${permissions.includes('facture-controle-technique') ? 'border-right px-1 ' : ''}text-right">${invoice.articles[key].nbUnites}</td>
    //                             <td class="text-right${permissions.includes('facture-controle-technique') ? ' border-right px-1' : ''}">${localPrice.toFixed(2)}</td>
    //                             <td class="text-right${permissions.includes('facture-controle-technique') ? ' px-1' : ''}">${localTotalPrice.toFixed(2)}</td>
    //                         </tr>
    //                     `;
    //                 }

    //                 for (const key in invoice.services) {
    //                     const selectedPrice = invoice.services[key].selectedPrice;
    //                     const totalPrice = Number.parseFloat(invoice.services[key].nbUnites) * selectedPrice;
    //                     const localPrice = (selectedPrice * getVatFactor(invoice.services[key]['hasVat'])) * getRate(currency);
    //                     const localTotalPrice = (totalPrice + (invoice.services[key]['vatAmount'] ?? 0)) * getRate(currency);
    //                     invoiceTtc += localTotalPrice;
    //                     invoiceTableBody.innerHTML += `
    //                         <tr>
    //                             <td class="${permissions.includes('facture-controle-technique') ? 'border-right px-1' : ''}">${invoice.services[key].name}</td>
    //                             <td class="${permissions.includes('facture-controle-technique') ? 'border-right px-1 ' : ''}text-right">${invoice.services[key].nbUnites}</td>
    //                             <td class="text-right${permissions.includes('facture-controle-technique') ? ' border-right px-1' : ''}">${localPrice.toFixed(2)}</td>
    //                             <td class="text-right${permissions.includes('facture-controle-technique') ? ' px-1' : ''}">${localTotalPrice.toFixed(2)}</td>
    //                         </tr>
    //                     `;
    //                 }

    //                 for (const idx in invoice.articles) {
    //                     if (invoice.articles[idx].bonusApplicable) {
    //                         servicesForBonus.push(invoice.articles[idx]);
    //                     }
    //                 }

    //                 for (const idx in invoice.services) {
    //                     if (invoice.services[idx].bonusApplicable) {
    //                         servicesForBonus.push(invoice.services[idx]);
    //                     }
    //                 }

    //                 invoiceTotals.innerHTML = '';

    //                 // if (servicesForBonus.length > 0) {
    //                 //     if (bonusThreshold > 1) {
    //                 //         invoiceTotals.innerHTML = `<div class="mt-2"><em>N.B.: Bonus pour ${bonusThreshold} élts de même nature</em></small>`;
    //                 //     } else if (bonusThreshold === 1) {
    //                 //         invoiceTotals.innerHTML = `<div class="mt-2"><em>N.B.: Bonus de ${(bonusPercentage * 100).toFixed(2)} % pour tout achat</em></small>`;
    //                 //     }
    //                 // }

    //                 // invoiceTotals.innerHTML += `
    //                 //     <br><br>
    //                 //     <span>Total&nbsp;facture&nbsp;:&nbsp;${((companyHasVat ? invoiceTtc : invoice.total) * getRate(currency)).toFixed(2)}&nbsp;${currency}</span>
    //                 // `;

    //                 if ('number' === typeof invoice.discount && invoice.discount > 0) {
    //                     invoiceTotals.innerHTML += `<br><small>Réduction : ${(invoice.discount * getRate(currency)).toFixed(2)} ${currency}</small>`;
    //                 }

    //                 if ('number' === typeof invoice.workforce && invoice.workforce > 0) {
    //                     invoiceTotals.innerHTML += `<br><em><small>Main d'oeuvre : ${(invoice.workforce * getRate(currency)).toFixed(2)} ${currency}</small></em>`;
    //                 }

    //                 invoiceTotals.innerHTML += `<br><b>Total ${companyHasVat ? 'HT' : 'net'} : ${(invoiceNet * getRate(currency)).toFixed(2)} ${currency}</b>`;

    //                 if (companyHasVat) {
    //                     invoiceTotals.innerHTML += `<br><b>Total TTC : ${(invoiceTtc * getRate(currency)).toFixed(2)} ${currency}</b>`;
    //                 }

    //                 // if (invoice.type.indexOf('proforma') === -1) {
    //                     invoiceTotals.innerHTML += `<br>Mode de paiement : ${invoice.type.indexOf('proforma') === -1 ? invoice.paymentMode : '-'}`;
    //                 // }

    //                 if (permissions.includes('facture-controle-technique')) {
    //                     const wholePart = Math.floor(invoiceTtc);
    //                     const decimalPart = Math.round(100 * (invoiceTtc % 1));
    //                     let invoiceNetInFull = fullySpelledOut.writeInFull(wholePart);
    //                     if (0 < decimalPart) {
    //                         invoiceNetInFull += ' et ' + fullySpelledOut.writeInFull(decimalPart) + ' centimes';
    //                     }
    //                     invoiceTotals.innerHTML += `<br><br><b><em><small>Nous disons ${currency === 'Fc' ? 'francs congolais' : 'dollars américains'} ${invoiceNetInFull}</small></em></b>`;
    //                 }

    //                 if (invoice.type === 'credit' && invoiceTtc > invoice.amountPaid) {
    //                     invoiceTotals.innerHTML += `
    //                         <br>Avance : ${(invoice.amountPaid * getRate(currency)).toFixed(2)} ${currency}
    //                         <br>Reste à payer : ${(((companyHasVat ? invoiceTtc : invoiceNet) - invoice.amountPaid) * getRate(currency)).toFixed(2)} ${currency}
    //                     `;
    //                 }

    //                 // if ('undefined' !== typeof dateRetrait && ((permissions.indexOf('facture-controle-technique') === -1 && permissions.indexOf('pv-controle-technique') === -1 && !invoice.type.startsWith('proforma')) || invoice.type === 'credit')) {
    //                 // if ('undefined' !== typeof dateRetrait && new Date(dateRetrait.date).toLocaleDateString('en-US') !== new Date().toLocaleDateString('en-US') && permissions.indexOf('facture-controle-technique') === -1 && permissions.indexOf('pv-controle-technique') === -1 || invoice.type === 'credit') {
    //                 if ('undefined' !== typeof dateRetrait && new Date(dateRetrait.date).toLocaleDateString('en-US') !== new Date().toLocaleDateString('en-US') && permissions.indexOf('facture-controle-technique') === -1 && permissions.indexOf('pv-controle-technique') === -1 && invoice.type === 'credit') {
    //                     const today = (new Date()).toLocaleDateString('fr-FR', {year: 'numeric', month: 'long', day: 'numeric'});
    //                     const rendezVous = new Date(dateRetrait.date);
    //                     const rendezVousShort = rendezVous.toLocaleDateString('fr-FR', {year: 'numeric', month: 'long', day: 'numeric'});
    //                     invoiceTotals.innerHTML += `<br>Echéance : ${rendezVous.toLocaleDateString('fr-FR', today === rendezVousShort ? {year: 'numeric', month: 'short', day: 'numeric', hour: 'numeric', minute: 'numeric'} : 'Aujourd\'hui')}`;
    //                     invoiceFooter.className = 'mb-pb-reduce';
    //                 }

    //                 invoiceFooter.innerHTML = permissions.includes('facture-controle-technique')
    //                     ? `
    //                         <div class="d-flex justify-content-between w-100 mt-3">
    //                             <div class="flex-grow-1">
    //                                 <em>
    //                                     <b>Merci ${invoice.type === 'proforma' ? 'de nous retourner cette facture proforma signée avec la mention "bon pour accord"' : 'pour votre confiance'}</b>
    //                                 </em>
    //                             </div>
    //                             <div class="flex-grow-1 text-right">
    //                                 <em class="text-right">Le centre de contrôle technique</em>
    //                             </div>
    //                         </div>
    //                     `
    //                     : `
    //                         <b>Date : ${(new Date()).toLocaleDateString('fr-FR', {year: 'numeric', month: 'short', day: 'numeric', hour: 'numeric', minute: 'numeric'})}</b>
    //                     `
    //                 ;

    //                 if (typeof bonusThreshold === 'number' && bonusThreshold > 0 && typeof bonusPercentage === 'number' && bonusPercentage > 0 && typeof client.totalBonus === 'number' && client.totalBonus > 0) {
    //                     invoiceFooter.innerHTML += `<br><br>N.B.: Votre compte bonus vient d'atteindre ${(client.totalBonus * getRate(currency)).toFixed(2)}${currency} utilisables pour payer vos prochains achats chez nous.`;
    //                 }

    //                 invoiceFooter.innerHTML += generateNalediSignature(permissions.includes('facture-controle-technique') ? 'invoice-a4' : 'invoice');

    //                 invoiceTemplate.removeAttribute('hidden');
    //                 spinner.setAttribute('hidden', 'hidden');
    //                 // import('./styles/print-invoice.css').then((module) => {
    //                 //     module.loadPageInto('body');
    //                 // });

    //                 // printJS({
    //                 //     printable: `/public/uploads/logos/${maison['logo']}`,
    //                 //     type: 'image'
    //                 // });
    //                 printJS({
    //                     printable: 'invoice-template',
    //                     type: 'html',
    //                     header: `
    //                         <div id="invoice-header">
    //                             ${generateDocumentHeader(permissions.includes('facture-controle-technique') ? 'invoice-a4' : 'invoice')}
    //                             <h3 class="my-0 py-0">${printType === 'DUPLICATA' ? 'FACTURE' : printType} N°${invoice.id}${invoice.type === 'proforma' ? (printType === 'FACTURE' ? ' (PROFORMA)' : (printType === 'DUPLICATA' ? ' PROFORMA DUPLICATA': '')) : (printType === 'DUPLICATA' ? ' (DUPLICATA)' : '')}</h3>
    //                         </div>
    //                     `,
    //                     maxWidth: invoiceSettings.paperFormat.maxWidth,
    //                     style: printInvoiceStyles
    //                 });

    //                 sessionStorage.removeItem('invoiceId');
    //                 invoiceTemplate.setAttribute('hidden', 'hidden');
    //             });
    //         }
    //     }).catch(() => {
    //         spinner.setAttribute('hidden', 'hidden');
    //         showAlert('Echec d\'impression ! Vérifiez votre connexion !', 'danger', false);
    //     });

    //     spinner.removeAttribute('hidden');

    // // } else {
    // //     showAlert('Aucune facture à imprimer !', 'warning', false);
    // }
}

function printReceipt(invoiceId, options = {}) {
    window.location.assign(`${localStorage.getItem('baseUrl')}/receipts/${invoiceId}/print/roll58?itemsContainer=${options.itemsContainer}`);
}

async function printLicenseReceipt(licenseId, options = {}) {
    const url = `${localStorage.getItem('baseUrl')}/license_receipts/${licenseId}/print/roll58?totalCost=${options.totalCost}&amountPaid=${options.amountPaid}`;
    const blob = await getFileFromServer(url);
    printJS({ printable: URL.createObjectURL(blob), type: 'pdf' });
}

window.cloturer = function(event, divToPrint = '') {
    const headers = new Headers();
    const spinner = document.querySelector('#spinner');
    event.target.removeAttribute('hidden');
    headers.append('Content-Type', 'application/json');
    fetch(`${localStorage.getItem('baseUrl')}/sales/clotures/new`, {
        method: 'POST',
        headers: headers,
        body: JSON.stringify(clotureElts)
    }).then(resp => {
        if (resp.ok) {
            resp.text().then(responseBody => {
                const {message, data} = JSON.parse(responseBody);
                const rapportClotureTemplate = document.getElementById('rapport-cloture-template');

                rapportClotureTemplate.removeAttribute('hidden');

                rapportClotureTemplate.innerHTML = `
                    <table class="w-100">
                        <tr>
                            <td>Ventes</td>
                            <td>${currency}${(((('string' === typeof data.ventes.total ? Number.parseFloat(data.ventes.total) : (null === data.ventes.total ? 0 : data.ventes.total))) + ('string' === typeof data.ventes.workforce ? Number.parseFloat(data.ventes.workforce) : (null === data.ventes.workforce ? 0 : data.ventes.workforce)) - ('string' === typeof data.ventes.discount ? Number.parseFloat(data.ventes.discount) : (null === data.ventes.discount ? 0 : data.ventes.discount))) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Cash</td>
                            <td>${currency}${(('string' === typeof data.cash.amountPaid ? Number.parseFloat(data.cash.amountPaid) : (null === data.cash.amountPaid ? 0 : data.cash.amountPaid)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Crédits</td>
                            <td>${currency}${((('string' === typeof data.credits.total ? Number.parseFloat(data.credits.total) : (null === data.credits.total ? 0 : data.credits.total)) + ('string' === typeof data.credits.workforce ? Number.parseFloat(data.credits.workforce) : (null === data.credits.workforce ? 0 : data.credits.workforce)) - ('string' === typeof data.credits.discount ? Number.parseFloat(data.credits.discount) : (null === data.credits.discount ? 0 : data.credits.discount))) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Paiements dettes</td>
                            <td>${currency}${(('string' === typeof data.paiementsDettes ? Number.parseFloat(data.paiementsDettes) : (null === data.paiementsDettes ? 0 : data.paiementsDettes)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Dépenses</td>
                            <td>${currency}${(('string' === typeof data.depenses ? Number.parseFloat(data.depenses) : (null === data.depenses ? 0 : data.depenses)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Paiements par bonus</td>
                            <td>${currency}${((('string' === typeof data.paiementsParBonus.totalBonus ? Number.parseFloat(data.paiementsParBonus.totalBonus) : (null === data.paiementsParBonus.totalBonus ? 0 : data.paiementsParBonus.totalBonus)) + Number.parseFloat(data.paiementsParBonus.vatAmount ?? 0)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Paiements par caution</td>
                            <td>${currency}${((('string' === typeof data.paiementsParCaution.totalCaution ? Number.parseFloat(data.paiementsParCaution.totalCaution) : (null === data.paiementsParCaution.totalCaution ? 0 : data.paiementsParCaution.totalCaution)) + Number.parseFloat(data.paiementsParCaution.vatAmount ?? 0)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Montant du</td>
                            <td>${currency}${(('string' === typeof data.montantDu ? Number.parseFloat(data.montantDu) : (null === data.montantDu ? 0 : data.montantDu)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Montant versé</td>
                            <td>${currency}${(('string' === typeof data.montantVerse ? Number.parseFloat(data.montantVerse) : (null === data.montantVerse ? 0 : data.montantVerse)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                        <tr>
                            <td>Solde</td>
                            <td>${currency}${(('string' === typeof data.solde ? Number.parseFloat(data.solde) : (null === data.solde ? 0 : data.solde)) * getRate(currency)).toFixed(2)}</td>
                        </tr>
                    </table>
                    <div class="w-90 text-right mt-3">Fait par ${data.doneBy.fullName ?? data.doneBy.username}</div>
                    <div class="w-90 text-right">Le ${data.createdAt}</div>
                `;

                cloture = data;

                setTimeout(async () => {
                    printJS({
                        printable: 'rapport-cloture-template',
                        type: 'html',
                        header: `
                            <div class="w-90 text-center">
                                ${await generateDocumentHeader('cloture')}
                                <h3 class="w-100 text-center border" id="title-cloture">RAPPORT DE CLOTURE</h3>
                            </div>
                        `,
                        maxWidth: invoiceSettings.paperFormat.maxWidth,
                        style: `
                                * {
                                font-family: monospace;
                                /* font-size: smaller !important; */
                            }
                        
                            .text-right {
                                text-align: right !important;
                            }
                        
                            .text-center {
                                text-align: center !important;
                            }
                        
                            .mt-3 {
                                margin-top: 1.8em;
                            }
                        
                            .border {
                                border: 1px solid #000;
                            }
                        
                            .border-bottom-dashed {
                                border-bottom: 1px solid dashed;
                            }
                        
                            .w-100 {
                                width: 100% !important;
                            }
                        
                            .w-90 {
                                width: 90% !important;
                            }
                        
                            .w-75 {
                                width: 75% !important;
                            }
                        
                            .w-70 {
                                width: 70% !important;
                            }
                        
                            .w-60 {
                                width: 60% !important;
                            }
                        
                            .w-50 {
                                width: 50% !important;
                            }
                        
                            .w-40 {
                                width: 40 !important;
                            }
                        
                            .w-30 {
                                width: 30% !important;
                            }
                        
                            .w-25 {
                                width: 25% !important;
                            }
                        
                            #rapport-cloture-template {
                                width: 100% !important;
                            }
                        
                            #company-cloture {
                                /* margin-top: -25px !important; */
                                margin-bottom: -5px !important;
                            }
                        
                            #title-cloture {
                                margin-top: 0px !important;
                                margin-bottom: -2px !important;
                            }
                        
                            #print-naledi-signature {
                                text-align: center;
                                width: 100% !important;
                                border-top: 1px dashed #000;
                                margin-top: 10px;
                                font-size: smaller;
                            }
                        `
                    });
                    rapportClotureTemplate.setAttribute('hidden', 'hidden');
                }, 1000);
                spinner.setAttribute('hidden', 'hidden');
                showAlert(message, 'success', false);
            });
        }
    }).catch(() => {
        spinner.setAttribute('hidden', 'hidden');
        showAlert('La clôture n\'a pas abouti. Vérifiez votre connexion !', 'danger', false);
    });
    spinner.removeAttribute('hidden');
};

function populatechartboad(invoice) {
    const invoiceId = invoice.id;

    fetch(`${localStorage.getItem('baseUrl')}/factures/${invoiceId}/populate/cartboard`, {
        method: 'GET'
    }).then(resp => {
        if (resp.ok) {
            resp.text().then(data => {
                const invoiceData = JSON.parse(data).data;
                const workforceElt = document.querySelector('#workforce');
                const discountElt = document.querySelector('#discount');
                const ttcAmountElt = document.querySelector('#net-ttc');

                for (const idx in currentInvoice.services) {
                    const service = currentInvoice.services[idx];
                    currentInvoice = addToCart(service.serviceId, (0 - Math.abs(service.quantity)), currentInvoice);
                }

                for (const idx in currentInvoice.articles) {
                    const article = currentInvoice.articles[idx];
                    currentInvoice = addToCart(article.serviceId, (0 - Math.abs(article.quantity)), currentInvoice);
                }

                document.querySelectorAll('#cart > tbody > tr').forEach((rowElt) => {
                    rowElt.parentNode.removeChild(rowElt);
                });

                invoice = { id: invoiceId, articles: {}, services: {}, total: 0, discount: 0 };
                // Update total elements
                document.querySelector('#total').textContent = currency + ' 0.00';
                if (null !== discountElt) {
                    discountElt.textContent = currency + ' 0.00';
                }
                if (null !== workforceElt) {
                    workforceElt.textContent = currency + ' 0.00';
                }
                document.querySelector('#net').textContent = currency + ' 0.00';
                if (ttcAmountElt !== null) {
                    ttcAmountElt.textContent = currency + ' 0.00';
                }

                invoice.type = invoiceData.typeFacture;
                invoice.workforce = invoiceData.workforce;
                invoice.workforcePercent = invoiceData.workforcePercent;

                Object.assign(currentInvoice, invoice);
                updateClientDetails(currentInvoice);
                updateGrid(invoiceData.services);

                invoiceData.services.forEach(serv => {
                    currentInvoice = addToCart(serv.serviceId, Math.abs(serv.qty), currentInvoice);
                });
            });
        }
    }).catch(() => {
        showAlert('Impossible d\'atteindre le serveur ! Vérifiez votre connexion !', 'danger', false);
    });
}

function updateClientDetails(invoice) {
    const headers = new Headers();
    headers.append('Content-Type', 'application/json');

    fetch(`${localStorage.getItem('baseUrl')}/factures/updatetotalelements/${invoice.id}`, {
        method: 'GET',
        headers: headers
    }).then(resp => {
        if (resp.ok) {
            resp.text().then(jsonData => {
                const data = JSON.parse(jsonData);
                const clientInput = document.querySelector('#client-autocomplete > input');
                const c = clients.find(client => client.id === ('string' === typeof data.clientId ? Number.parseInt(data.clientId, 10) : data.clientId));

                clientInput.value = '';
                currentInvoice.client = typeof c === 'undefined' ? { id: null, nomClient: 'Client anonyme', totalFactures: 0, totalBonus: 0.00, totalCaution: 0.00 } : c;
                currentInvoice.client.totalFactures = isNaN(currentInvoice.client.totalFactures) || 'undefined' === currentInvoice.client.totalFactures || null === currentInvoice.client.totalFactures ? 0 : ('string' === typeof currentInvoice.client.totalFactures ? Number.parseInt(currentInvoice.client.totalFactures, 10) : currentInvoice.client.totalFactures);
                currentInvoice.client.totalBonus = isNaN(currentInvoice.client.totalBonus) || 'undefined' === currentInvoice.client.totalBonus || null === currentInvoice.client.totalBonus ? 0 : ('string' === typeof currentInvoice.client.totalBonus ? Number.parseFloat(currentInvoice.client.totalBonus) : currentInvoice.client.totalBonus);
                currentInvoice.client.totalCaution = isNaN(currentInvoice.client.totalCaution) || 'undefined' === currentInvoice.client.totalCaution || null === currentInvoice.client.totalCaution ? 0 : ('string' === typeof currentInvoice.client.totalCaution ? Number.parseFloat(currentInvoice.client.totalCaution) : currentInvoice.client.totalCaution);
                document.querySelector('#customerName').textContent = currentInvoice.client.nomClient;
                document.querySelector('#total-factures').textContent = currentInvoice.client.totalFactures;
                document.querySelector('#total-bonus').textContent = ((currentInvoice.client.totalBonus ?? 0) * getRate(currency)).toFixed(2);
                document.querySelector('#total-caution').textContent = ((currentInvoice.client.totalCaution ?? 0) * getRate(currency)).toFixed(2);

                invoice.licenseId = data.licenseId ?? 0;
                licenseId = invoice.licenseId;
            });
        }
    }).catch(() => {
        showAlert('Impossible d\'atteindre le serveur ! Vérifiez votre connexion !', 'danger', false);
    });
}

window.printReceipt = async function() {
    const receiptContainer = document.querySelector('#debt-payment-receipt');

    receiptContainer.innerHTML = `
        <div id="debt-payment-receipt-body">
            <div>Client : ${currentInvoice.client.nomClient}</div>
            <div class="font-weight-bold">Montant payé : ${(amountPaidDebts * getRate(currency)).toFixed(2) + ' ' + currency}</div>
            <div class="font-weight-bold">Solde : ${((amountDueSold - amountPaidDebts) * getRate(currency)).toFixed(2) + ' ' + currency}</div>
            <div>Reçu par : ${user}</div>
            <div>Date : ${(new Date()).toLocaleDateString('fr-FR', {year: 'numeric', month: 'long', day: 'numeric'})}</div>
        </div>
    `;

    receiptContainer.innerHMTL += generateNalediSignature();

    receiptContainer.removeAttribute('hidden');
    printReceiptModal.hide();

    printJS({
        printable: 'debt-payment-receipt',
        type: 'html',
        header: `
            ${await generateDocumentHeader('debt-payment')}
            <h3 class="text-center border" id="title-debt-payment">REÇU DE PAIEMENT DETTE</h3>
        `,
        maxWidth: invoiceSettings.paperFormat.maxWidth,
        style: `
                * {
                font-family: monospace;
                /* font-size: smaller !important; */
            }

            #debt-payment-receipt,
            #debt-payment-receipt-body > div {
                width: 100% !important;
            }

            /* #debt-payment-receipt-body {
                display: flex;
                flex-direction: column;
                align-items: center;
            } */

            .text-center {
                text-align: center;
            }

            .font-weight-bold {
                font-weight: bold;
            }

            .border {
                border: 1px solid #000;
            }

            .border-bottom-dashed {
                border-bottom: 1px dashed #000;
            }

            .border-top-dashed {
                border-top: 1px dashed #000;
            }

            .py-2 {
                padding-top: 1.2em;
                padding-bottom: 1.2em;
            }

            .mt-3 {
                margin-top: 1.8em;
            }

            .mt-2 {
                margin-top: 1.2em;
            }

            .pt-2 {
                padding-top: 1.2em;
            }

            .w-100 {
                width: 100% !important;
            }

            .w-90 {
                width: 90% !important;
            }

            .w-75 {
                width: 75% !important;
            }

            .w-70 {
                width: 70% !important;
            }

            .w-60 {
                width: 60% !important;
            }

            .w-50 {
                width: 50% !important;
            }

            .w-40 {
                width: 40 !important;
            }

            .w-30 {
                width: 30% !important;
            }

            #print-naledi-signature {
                text-align: center;
                width: 100% !important;
                border-top: 1px dashed #000;
                margin-top: 10px;
                font-size: smaller;
            }

            .w-25 {
                width: 25% !important;
            }

            #company-debt-payment {
                /* margin-top: -25px !important; */
                margin-bottom: -5px !important;
            }

            #title-debt-payment {
                margin-top: 0px !important;
                margin-bottom: 0px !important;
            }
        `
    });

    receiptContainer.setAttribute('hidden', 'hidden');
};

window.selectClientItem = function(event) {
    const currentItem = event.currentTarget;
    const client = clients.find(c => c.nomClient === currentItem.textContent);
    const clientInput = document.querySelector('#client');
    clientInput.value = client['nomClient'];
    clientInput.dataset.clientId = client['clientId'] ?? client['id'];
    clientDropdownMenu.style.display = 'none';
};

window.selectUsageVehiculeItem = function(event) {
    const currentItem = event.currentTarget;
    const usageVehicule = usagesVehicule.find(u => u === currentItem.textContent);
    const usageVehiculeInput = document.querySelector('#usageVehicule');
    usageVehiculeInput.value = usageVehicule;
    usageVehiculeInput.dataset.usageVehicule = usageVehicule;
    usageVehiculeDropdownMenu.style.display = 'none';
};

window.selectVehicleItem = function(event) {
    const currentItem = event.currentTarget;
    const vehicle = vehicles.find(v => v.id === Number.parseInt(currentItem.dataset.id, 10));
    const autocompleteId = currentItem.parentNode.id.includes('vehicle-') ? 'vehicule-' + currentItem.parentNode.id.split('-')[1] : 'numeroImmatriculation';
    const prefix = currentItem.parentNode.id.includes('vehicle-') ? 'vehicle-' + currentItem.parentNode.id.split('-')[1] : 'immatriculation';
    document.querySelector('#' + autocompleteId).dataset.id = vehicle['id'];

    if (prefix === 'immatriculation') {
        for (const key in vehicle) {
            let elt = document.querySelector('#' + key);
            if (null !== elt) {
                elt.value = vehicle[key];
            }
            if (key === 'clientId') {
                elt = document.querySelector('#client');
                elt.value = vehicle['nomClient'];
                elt.dataset.clientId = vehicle[key];
            }
        }
    } else {
        const vehicleDetails = [vehicle.genre, vehicle.marque, vehicle.typeOuModele];
        document.querySelector('#vehicule-' + currentItem.parentNode.id.split('-')[1]).value = vehicle.numeroImmatriculation + ' (' + vehicleDetails.join(' - ') + ')';
    }

    // immatriculationDropdownMenu = document.querySelector('#immatriculation-dropdown')
    document.querySelector('#' + prefix + '-dropdown').style.display = 'none';
};

async function newControle() {
    // let options = '';
    let optionsArticle = '';
    // const vehicleSelect = document.querySelector('#vehicule-controle');
    const articleSelect = document.querySelector('#article-controle');

    // vehicles.forEach(v => {
    //     options += `<option value="${v.id}"${Number.parseInt(vehicleSelect.value) === v.id ? ' selected' : ''}>${v.genre} (${v.numeroImmatriculation})</option>`;
    // });

    services.filter(service => service.type === 2).forEach(article => {
        optionsArticle += `<option value="${article.serviceId}"${Number.parseInt(articleSelect.value) === article.serviceId ? ' selected' : ''}>${article.name}</option>`;
    });

    articleSelect.innerHTML = optionsArticle;
    // const { data } = await fetchLicenseCost(articleSelect.value);
    // document.querySelector('#total-cost-license').focus();
    // document.querySelector('#total-cost-license').value = data.unitPrice;
    newControleModal.show();
}

function newExpertise() {
    let options = '';
    const vehicleSelect = document.querySelector('#vehicule-expertise');

    vehicles.forEach(v => {
        options += `<option value="${v.id}"${Number.parseInt(vehicleSelect.value) === v.id ? ' selected' : ''}>${v.genre} (${v.numeroImmatriculation})</option>`;
    });

    vehicleSelect.innerHTML = options;
    newExpertiseModal.show();
}

window.newControleGarage = async function() {
    if (document.querySelector('#pill-tab-ct').classList.value.indexOf('active') > -1) {
        await newControle();
    } else if (document.querySelector('#pill-tab-ev').classList.value.indexOf('active') > -1) {
        await newExpertise();
    }
};

window.printDailyReport = function(e) {
    if (permissions.includes('rapport')) {
        const spinner = document.querySelector('#spinner');
        spinner.removeAttribute('hidden');
        fetch(`${localStorage.getItem('baseUrl')}/invoices/dailyreport`, {
            method: 'GET',
            headers: new Headers({ 'X-Requested-With': 'XMLHttpRequest' })
        }).then(resp => {
            if (resp.ok) {
                resp.text().then(data => {
                    const { invoices, debtPayments, cautions, stock } = JSON.parse(data).data;
                    console.log(invoices);
                    const dailyReport = document.querySelector('#daily-report');
                    let index = 0;
                    let totalInvoices = 0;
                    let totalDebtPayments = 0;
                    let totalInvoiceAdvances = 0;
                    let totalInvoiceSolds = 0;
                    let dailyCautions = '';
                    let procurements = '';

                    let dailyInvoices = `
                        <table>
                            <thead>
                                <tr>
                                    <th class="text-center" colspan="7">Factures émises</th>
                                </tr>
                                <tr>
                                    <th class="text-right">#</th>
                                    <th>Client</th>
                                    <th class="text-right">Montant</th>
                                    <th class="text-right">Avance</th>
                                    <th class="text-right">Reste</th>
                                    <th>Rendez-vous</th>
                                    <th>N°&nbsp;téléphone</th>
                                </tr>
                            </thead>
                            <tbody>
                    `;

                    let dailyDebtPayments = `
                        <table>
                            <thead>
                                <tr>
                                    <th class="text-center" colspan="4">Factures payées</th>
                                </tr>
                                <tr>
                                    <th class="text-right">#</th>
                                    <th>Client</th>
                                    <th>N°&nbsp;Facture</th>
                                    <th class="text-right">Montant</th>
                                </tr>
                            </thead>
                            <tbody>
                    `;

                    let dailyInvoiceAdvances = `
                        <table>
                            <thead>
                                <tr>
                                    <th class="text-center" colspan="4">Avances sur factures émises</th>
                                </tr>
                                <tr>
                                    <th class="text-right">#</th>
                                    <th>Client</th>
                                    <th>N°&nbsp;Facture</th>
                                    <th class="text-right">Montant</th>
                                </tr>
                            </thead>
                            <tbody>
                    `;

                    if (cautions.length > 0) {
                        dailyCautions = `
                            <table>
                                <thead>
                                    <tr>
                                        <th class="text-center" colspan="4">Cautions</th>
                                    </tr>
                                    <tr>
                                        <th class="text-right">#</th>
                                        <th>Client</th>
                                        <th class="text-right">Montant</th>
                                        <th class="text-right">Reste</th>
                                    </tr>
                                </thead>
                                <tbody>
                            `;
                    }

                    if (stock.todaySales.length > 0) {
                        procurements = `
                            <table>
                                <thead>
                                    <tr>
                                        <th class="text-center" colspan="7">Rapport stock</th>
                                    </tr>
                                    <tr>
                                        <th class="text-right">#</th>
                                        <th>Article</th>
                                        <th class="text-right">Entrées</th>
                                        <th class="text-right">Sorties</th>
                                        <th class="text-right">Ventes</th>
                                        <th class="text-right">Aujourd'hui</th>
                                        <th class="text-right">Solde</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                    }

                    invoices.forEach((invoice, idx) => {
                        const invoiceTtc = invoice['total'] + (invoice['vatAmount'] ?? 0) - (invoice['discount'] ?? 0);
                        const invoiceSold = invoiceTtc - (invoice['amountPaid'] ?? 0);
                        totalInvoices += invoiceTtc;
                        totalInvoiceSolds += invoiceSold;
                        dailyInvoices += `
                            <tr>
                                <td class="text-right">${idx + 1}</td>
                                <td class="text-center">${typeof invoice['nomClient'] === 'string' ? invoice['nomClient'] : '-'}</td>
                                <td class="text-right">${currency} ${(invoiceTtc * getRate(currency))?.toFixed(2)}</td>
                                <td class="text-right">${currency} ${((invoice['amountPaid'] ?? 0) * getRate(currency)).toFixed(2)}</td>
                                <td class="text-right">${currency} ${(invoiceSold * getRate(currency))?.toFixed(2)}</td>
                                <td></td>
                                <td class="text-center">${typeof invoice['telephone'] === 'string' ? invoice['telephone'] : '-'}</td>
                            </tr>
                        `;
                        if (invoice['amountPaid'] > 0 && ['caution', 'bonus'].indexOf(invoice['paymentMode']) === -1) {
                            totalInvoiceAdvances += invoice['amountPaid'];
                            index++;
                            dailyInvoiceAdvances += `
                                <tr>
                                    <td class="text-right">${index}</td>
                                    <td class="text-center">${typeof invoice['nomClient'] === 'string' ? invoice['nomClient'] : '-'}</td>
                                    <td class="text-center">${invoice['id']}</td>
                                    <td class="text-right">${currency} ${(invoice['amountPaid'] * getRate(currency))?.toFixed(2)}</td>
                                </tr>
                            `;
                        }
                    });

                    debtPayments.forEach((debtPayment, idx) => {
                        totalDebtPayments += debtPayment['montantPaye'];
                        dailyDebtPayments += `
                            <tr>
                                <td>${idx + 1}</td>
                                <td>${debtPayment['nomClient']}</td>
                                <td>${debtPayment['invoiceId']}</td>
                                <td class="text-right">${currency} ${(debtPayment['montantPaye'] * getRate(currency))?.toFixed(2)}</td>
                            </tr>
                        `;
                    });

                    if (debtPayments.length > index) {
                        for (let i = 0, count = debtPayments.length - index; i < count; i++) {
                            dailyInvoiceAdvances += `
                                <tr>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                </tr> 
                            `;
                        }
                    }

                    if (debtPayments.length < index) {
                        for (let i = 0, count = index - debtPayments.length; i < count; i++) {
                            dailyDebtPayments += `
                                <tr>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                    <td class="text-center">-</td>
                                </tr>
                            `;
                        }
                    }

                    if (cautions.length > 0) {
                        let totalCaution = 0;
                        let totalCautionRemainder = 0;
                        cautions.forEach((caution, idx) => {
                            const amount = caution.amount;
                            const remainder = caution.amount - (caution.amountUsed ?? 0);
                            totalCaution += amount;
                            totalCautionRemainder += remainder;
                            dailyCautions += `
                                <tr>
                                    <td class="text-right">${idx + 1}</td>
                                    <td>${caution.nomClient}</td>
                                    <td class="text-right">${currency} ${(amount * getRate(currency)).toFixed(2)}</td>
                                    <td class="text-right">${currency} ${(remainder * getRate(currency)).toFixed(2)}</td>
                                </tr>
                            `;
                        });
                        dailyCautions += `
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2"><b>TOTAL</b></td>
                                        <td class="text-right"><b>${currency} ${(totalCaution * getRate(currency)).toFixed(2)}</b></td>
                                        <td class="text-right"><b>${currency} ${(totalCautionRemainder * getRate(currency)).toFixed(2)}</b></td>
                                    </tr>
                                </tfoot>
                            </table><br>
                        `;
                    }

                    if (stock.todaySales.length > 0) {
                        const groupedProcurements = groupArrayOfObjects(stock.procurements, 'article');
                        let groupedSales;
                        let groupedTodaySales;
                        let groupedOutOfStock;
                        let idx = 0;

                        if (stock.sales.length > 0) {
                            groupedSales = groupArrayOfObjects(stock.sales, 'article');
                        }

                        if (stock.todaySales.length > 0) {
                            groupedTodaySales = groupArrayOfObjects(stock.todaySales, 'article');
                        }

                        if (stock.outOfStock.length > 0) {
                            groupedOutOfStock = groupArrayOfObjects(stock.outOfStock, 'article');
                        }

                        for (const key in groupedProcurements) {
                            const posDetail = stock.posDetails.find(detail => detail.article === key);
                            idx++;
                            procurements += `
                                <tr>
                                    <td class="text-right">${idx}</td>
                                    <td>${key}</td>
                                    <td class="text-right">${groupedProcurements[key].reduce((accu, next) => accu + next['quantity'], 0)}</td>
                            `;

                            procurements += '<td class="text-right">' + ((typeof groupedOutOfStock !== 'undefined' && Object.keys(groupedOutOfStock).indexOf(key) > -1) ? groupedOutOfStock[key].reduce((accu, next) => accu + Math.abs(next['quantity']), 0) : 0) + '</td>';
                            procurements += '<td class="text-right">' + ((typeof groupedSales !== 'undefined' && Object.keys(groupedSales).indexOf(key) > -1) ? groupedSales[key].reduce((accu, next) => accu + Math.abs(next['quantity']), 0) : 0) + '</td>';
                            procurements += '<td class="text-right">' + ((typeof groupedTodaySales !== 'undefined' && Object.keys(groupedTodaySales).indexOf(key) > -1) ? groupedTodaySales[key].reduce((accu, next) => accu + Math.abs(next['quantity']), 0) : 0) + '</td>';

                            procurements += `
                                    <td class="text-right">${typeof posDetail !== 'undefined' && posDetail !== null ? posDetail.quantity : 0}</td>
                                </tr>
                            `;
                        }

                        procurements += `
                                </tbody>
                            </table>
                        `;
                    }

                    dailyInvoices += `
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="2"><b>TOTAL (1)</b></td>
                                    <td class="text-right"><b>${currency} ${(totalInvoices * getRate(currency))?.toFixed(2)}</b></td>
                                    <td class="text-right"><b>${currency} ${(totalInvoiceAdvances * getRate(currency))?.toFixed(2)}</b></td>
                                    <td class="text-right"><b>${currency} ${(totalInvoiceSolds * getRate(currency))?.toFixed(2)}</b></td>
                                    <td class="text-center"><b>-</b></td>
                                    <td class="text-center"><b>-</b></td>
                                </tr>
                            </tfoot>
                        </table><br>
                    `;

                    dailyInvoiceAdvances += `
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3"><b>TOTAL (3)</b></td>
                                    <td class="text-right"><b>${currency} ${(totalInvoiceAdvances * getRate(currency))?.toFixed(2)}</b></td>
                                </tr>
                            </tfoot>
                        </table><br>
                    `;

                    dailyDebtPayments += `
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3"><b>TOTAL (2)</b></td>
                                    <td class="text-right"><b>${currency} ${(totalDebtPayments * getRate(currency))?.toFixed(2)}</b></td>
                                </tr>
                            </tfoot>
                        </table>
                    `;

                    dailyReport.innerHTML = dailyInvoices
                        + `<div class="d-flex flex-column mb-5" id="daily-payments-section"><div class="d-flex flex-row justify-content-between" id="daily-payments">`
                        + dailyDebtPayments
                        + dailyInvoiceAdvances
                        + `</div><br><div class="border border-dark w-100" id="daily-report-totals-2-3"><b>&nbsp;TOTAUX (2) + (3) : ${currency} ${((totalDebtPayments + totalInvoiceAdvances) * getRate(currency))?.toFixed(2)}</b></div>`
                        + '</div>'
                    ;

                    if (cautions.length > 0) {
                        dailyReport.innerHTML += dailyCautions;
                    }

                    if (stock.todaySales.length > 0) {
                        dailyReport.innerHTML += procurements;
                    }

                    dailyReport.innerHTML += `<br><div class="text-right w-100">${user}</div>`;
                    dailyReport.removeAttribute('hidden');
                    spinner.setAttribute('hidden', 'hidden');

                    printJS({
                        printable: 'daily-report',
                        type: 'html',
                        header: `
                            <div class="d-flex justify-content-between" id="daily-report-header">
                                <div id="daily-report-logo">
                                    <h2 class="w-25">${maison['nomSociete']}</h2>
                                </div>
                                <div>${(new Date()).toLocaleDateString('fr-FR', { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' })}</div>
                            </div>
                            <h4 class="text-center font-weight-bold">Rapport journalier <span>${pos}</span></h4>
                        `,
                        maxWidth: paperFormats.find(p => p.key === 'a4').maxWidth,
                        // styles: printDailyReportStyles
                        style: `
                            .text-center { text-align: center; }
                            .text-right { text-align: right; }
                            .font-weight-bold { font-weight: bold; }
                            .w-100 { width: 100%; }
                            .border { border: 1px solid #000; }
                            .border-dark { border-color: #000; }
                            .mt-2 { margin-top: 2px; }
                            .mb-5 { margin-bottom: 5px; }
                            .d-flex { display: flex; }
                            .flex-column { flex-direction: column; }
                            .flex-row { flex-direction: row; }
                            .justify-content-between { justify-content: space-between; }

                            #daily-report {
                                font-family: Arial;
                                margin: 0;
                                padding: 0;
                                color: #000;
                            }
                        
                            table {
                                border: 1px solid #000 !important;
                                border-collapse: collapse;
                                margin-bottom: 10px;
                            }
                        
                            #daily-report > table,
                            #daily-payments {
                                width: 100% !important;
                            }
                        
                            #daily-payments > table {
                                width: 50% !important;
                            }
                        
                            #daily-payments > table:first-child {
                                margin-right: 1% !important;
                            }
                        
                            #daily-payments > table:last-child {
                                margin-right: 0 !important;
                            }
                        
                            th, td {
                                border: 1px solid #000;
                                padding-left: 5px;
                                padding-right: 5px;
                            }
                        
                            thead > tr:first-child > th,
                            #daily-report-totals-2-3 {
                                background-color: #bbb;
                            }
                        
                            #daily-report-logo > img {
                                max-width: 500px !important;
                                margin-right: 0 !important;
                            }`
                    });

                    dailyReport.setAttribute('hidden', 'hidden');
                });
            }
        }).catch(() => {
            spinner.setAttribute('hidden', 'hidden');
            showAlert('Impossible d\'afficher le rapport ! Vérifiez votre connexion !', 'danger', false);
        });
    } else {
        showAlert('Vous n\'êtes pas autorisé de voir le rapport.', 'warning', false);
    }
}

window.logout = function() {
    window.location.assign(`${localStorage.getItem('baseUrl')}/logout`);
};

window.selectPrice = function(event) {
    const totalPriceElt = event.currentTarget;
    const serviceId = Number.parseInt(totalPriceElt.parentNode.dataset.serviceId, 10);
    const quantity = Number.parseFloat(totalPriceElt.parentNode.querySelector('td:nth-of-type(2)').textContent);
    const service = findServiceById(serviceId);
    const retailPriceElt = priceSelectModalElt.querySelector('#retail-price');
    const wholesalePriceElt = priceSelectModalElt.querySelector('#wholesale-price');
    const discountPriceElt = priceSelectModalElt.querySelector('#deflated-price');
    const changedPriceElt = priceSelectModalElt.querySelector('#changed-price');
    const vatFactor = getVatFactor(service.hasVat);

    retailPriceElt.value = service.unitPrice * vatFactor * getRate(currency);
    retailPriceElt.dataset.price = service.unitPrice;
    retailPriceElt.parentNode.querySelector('label').innerHTML = 'Détail<br>' + (service.unitPrice * vatFactor * getRate(currency)).toFixed(2);
    wholesalePriceElt.value = service.wholesalePrice * vatFactor * getRate(currency);
    wholesalePriceElt.dataset.price = service.wholesalePrice;
    wholesalePriceElt.parentNode.querySelector('label').innerHTML = 'Gros<br>' + (service.wholesalePrice * vatFactor * getRate(currency)).toFixed(2);
    discountPriceElt.value = service.deflatedPrice * vatFactor * getRate(currency);
    discountPriceElt.dataset.price = service.deflatedPrice;
    discountPriceElt.parentNode.querySelector('label').innerHTML = 'Cassé<br>' + (service.deflatedPrice * vatFactor * getRate(currency)).toFixed(2);
    retailPriceElt.checked = 'on';
    changedPriceElt.value = service.unitPrice * vatFactor * getRate(currency);

    [retailPriceElt, wholesalePriceElt, discountPriceElt].forEach(input => {
        input.addEventListener('click', (e) => {
            changedPriceElt.dataset.price = e.currentTarget.dataset.price;
            changedPriceElt.value = e.currentTarget.value;
        });
    });

    document.querySelector('#validate-price-change').addEventListener('click', () => {
        currentInvoice = addToCart(serviceId, quantity, currentInvoice, typeof changedPriceElt.dataset.price !== 'undefined' ? Number.parseFloat(changedPriceElt.dataset.price) : Number.parseFloat(changedPriceElt.value) / vatFactor);
        delete changedPriceElt.dataset.price;
        priceSelectModal.hide();
    }, {once: true});

    priceSelectModal.show();
};

function getVatRate(hasVat) {
    return companyHasVat && hasVat ? maison['vatRate'] : 0;
}

function getVatFactor(hasVat) {
    return 1 + getVatRate(hasVat);
}

window.customizeInvoice = function(event) {
    let paperFormatOptions = '';

    paperFormats.forEach((paperFormat) => {
        paperFormatOptions += `<option value="${paperFormat.key}"${invoiceSettings.paperFormat.key === paperFormat.key ? ' selected' : ''}>${paperFormat.name}</option>`;
    });

    invoiceCustomizationModalElt.querySelector('form').innerHTML = `
        <div class="my-4 form-group">
            <label for="paper-format" class="form-label">Format du papier par défaut</label>
            <select name="paper-format" id="paper-format" class="form-control">${paperFormatOptions}</select>
        </div>
        <div class="form-check form-switch d-flex align-items-center">
            <input type="checkbox" role="switch" class="form-check-input mt-0" name="display-logo" id="display-logo"${typeof invoiceSettings.displayLogo !== 'undefined' && invoiceSettings.displayLogo === 'on' ? ' checked' : ''}>
            <label for="display-logo" class="form-check-label ml-1 mb-0">&nbsp;Afficher le logo</label>
        </div>
        <div class="my-3">
            <h5 class="font-weight-bold">Eléments de l'entête</h5>
            <div class="row border rounded mx-1">
                <div class="col">
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-address" id="invoice-address"${typeof invoiceSettings.invoiceAddress !== 'undefined' && invoiceSettings.invoiceAddress === 'on' ? ' checked' : ''}>
                        <label for="invoice-address" class="form-check-label ml-1 mb-0">&nbsp;Addresse</label>
                    </div>
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-telephone" id="invoice-telephone"${typeof invoiceSettings.invoiceTelephone !== 'undefined' && invoiceSettings.invoiceTelephone === 'on' ? ' checked' : ''}>
                        <label for="invoice-telephone" class="form-check-label ml-1 mb-0">&nbsp;Téléphone</label>
                    </div>
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-email" id="invoice-email"${typeof invoiceSettings.invoiceEmail !== 'undefined' && invoiceSettings.invoiceEmail === 'on' ? ' checked' : ''}>
                        <label for="invoice-email" class="form-check-label ml-1 mb-0">&nbsp;E-mail</label>
                    </div>
                </div>
                <div class="col">
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-site" id="invoice-site"${typeof invoiceSettings.invoiceSite !== 'undefined' && invoiceSettings.invoiceSite === 'on' ? ' checked' : ''}>
                        <label for="invoice-site" class="form-check-label ml-1 mb-0">&nbsp;Site web</label>
                    </div>
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-rccm" id="invoice-rccm"${typeof invoiceSettings.invoiceRccm !== 'undefined' && invoiceSettings.invoiceRccm === 'on' ? ' checked' : ''}>
                        <label for="invoice-rccm" class="form-check-label ml-1 mb-0">&nbsp;Registre de commerce</label>
                    </div>
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-id-nat" id="invoice-id-nat"${typeof invoiceSettings.invoiceIdNat !== 'undefined' && invoiceSettings.invoiceIdNat === 'on' ? ' checked' : ''}>
                        <label for="invoice-id-nat" class="form-check-label ml-1 mb-0">&nbsp;Id nationale</label>
                    </div>
                </div>
                <div class="col">
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-tax-number" id="invoice-tax-number"${typeof invoiceSettings.invoiceTaxNumber !== 'undefined' && invoiceSettings.invoiceTaxNumber === 'on' ? ' checked' : ''}>
                        <label for="invoice-tax-number" class="form-check-label ml-1 mb-0">&nbsp;Numéro d'impôt</label>
                    </div>
                    <div class="form-check form-switch d-flex align-items-center my-2">
                        <input type="checkbox" role="switch" class="form-check-input mt-0" name="invoice-operating-auth" id="invoice-operating-auth"${typeof invoiceSettings.invoiceOperatingAuth !== 'undefined' && invoiceSettings.invoiceOperatingAuth === 'on' ? ' checked' : ''}>
                        <label for="invoice-operating-auth" class="form-check-label ml-1 mb-0">&nbsp;Autorisation</label>
                    </div>
                </div>
            </div>
        </div>
        <div class="my-3">
            <h5 class="font-weight-bold">Autres</h5>
            <div class="form-check form-switch d-flex align-items-center">
                <input type="checkbox" role="switch" class="form-check-input mt-0" name="product-department" id="product-department"${typeof invoiceSettings.productDepartment !== 'undefined' && invoiceSettings.productDepartment === 'on' ? ' checked' : ''}>
                <label for="product-department" class="form-check-label ml-1 mb-0">&nbsp;Associer chaque produit à un département</label>
            </div>
        </div>
    `;

    invoiceCustomizationModal.show();
};

window.saveInvoiceSettings = function() {
    const formData = new FormData(invoiceCustomizationModalElt.querySelector('form'));
    invoiceSettings = {};

    for (const pair of formData.entries()) {
        const value = pair[0] === 'paper-format' ? paperFormats.find(p => p.key === pair[1]) : pair[1];
        Object.assign(invoiceSettings, { [toCamelCase(pair[0])]: value });
    }

    localStorage.setItem('invoiceSettings', JSON.stringify(invoiceSettings));
    invoiceCustomizationModal.hide();
};

async function generateDocumentHeader(type) {
    // console.log(URL.createObjectURL(maison['logo']));
    // const response = await fetch(`${localStorage.getItem('baseUrl')}/company/logo`);
    // const logo = await response.blob();
    // console.log(logo);
    // console.log(URL.createObjectURL(logo));
    let header;

    // if (maison['logo'] !== null && invoiceSettings.displayLogo === 'on') {
    //     header = document.createElement('img');
    //     header.src = 'public/uploads/logos/' + maison['logo'];
    //     header.alt = 'Logo entreprise';
    //     header.style = 'width: 100% !important;';
    //     header.className = 'flat-logo-a4';
    // header = companyLogo;
        // header = `<img class="flat-logo-a4" id="width: 100% !important;" src="${URL.createObjectURL(companyLogo)}" alt="Logo entreprise">`;
    // } else {
    //     header = document.createElement('div');
    //     header.classList = 'h3 my-0 py-0';
    //     header.id = 'company-' + type;
    //     header.textContent = maison['nomSociete'];
    //    header = `<div class="h1 my-0 py-0" id="company-${type}">${maison['nomSociete']}</div>`;
    // }
    // console.log(header.outerHTML);
    // header = header.outerHTML;
    header = `<div class="h1 my-0 py-0" id="company-${type}" style="text-align: center; font-size: 30px;"><strong>${maison['nomSociete']}</strong></div>`;

    if (type !== 'invoice-a4' && type !== 'daily-report') {
        const companyIds = [];

        if (typeof maison.registreCommerce === 'string' && maison.registreCommerce.trim() !== '' && invoiceSettings.invoiceRccm === 'on') {
            companyIds.push('RCCM : ' + maison.registreCommerce);
        }

        if (typeof maison.idNationnal === 'string' && maison.idNationnal.trim() !== '' && invoiceSettings.invoiceIdNat === 'on') {
            companyIds.push('ID Nat. : ' + maison.idNationnal);
        }

        if (typeof maison.numImpot === 'string' && maison.numImpot.trim() !== '' && invoiceSettings.invoiceTaxNumber === 'on') {
            companyIds.push('N° Impôt : ' + maison.numImpot);
        }

        if (typeof maison.autorisationFct === 'string' && maison.autorisationFct.trim() !== ''  && invoiceSettings.invoiceOperatingAuth === 'on') {
            companyIds.push('Autorisation : ' + maison.autorisationFct);
        }

        if (typeof maison.adressePhysique === 'string' && maison.adressePhysique.trim() !== '' && invoiceSettings.invoiceAddress === 'on') {
            companyIds.push(maison.adressePhysique);
        }

        if (typeof maison.telephone === 'string' && maison.telephone.trim() !== '' && invoiceSettings.invoiceTelephone === 'on') {
            companyIds.push(maison.telephone);
        }

        if (typeof maison.mail === 'string' && maison.mail.trim() !== '' && invoiceSettings.invoiceEmail === 'on') {
            companyIds.push(maison.mail);
        }

        if (typeof maison.site === 'string' && maison.site.trim() !== '' && invoiceSettings.invoiceSite === 'on') {
            companyIds.push('Site web : ' + maison.site);
        }

        if (companyIds.length > 0) {
            header += `
                <div class="my-0 py-0 text-center">
                    <small><em>${companyIds.join(', ')}</em></small>
                </div>
            `;
        }
    }

    return header;
}

function generateNalediSignature(type = '') {
    return `<br><div id="print-naledi-signature"${type === 'invoice-a4' ? ' class="position-absolute b-0"' : ''}><small><em>REFLET by NalediServices.com</em></small></div>`;
}

window.attachDepartment = function(event) {
    const localDepartmentProductArr = event.currentTarget.id.split('-');
    const department = Number.parseInt(localDepartmentProductArr[1], 10);
    const product = Number.parseInt(localDepartmentProductArr[3], 10);
    departmentProductArr = departmentProductArr.filter(dp => dp.product !== product);
    departmentProductArr.push({ product, department });
};

window.fetchLicenseCost = async function(serviceId) {
    const spinner = document.querySelector('#spinner');
    spinner.removeAttribute('hidden');
    try {
        const response = await fetch(`${localStorage.getItem('baseUrl')}/services/${serviceId}`, {
            method: 'GET',
            headers: new Headers({ 'X-Requested-With': 'XMLHttpRequest' })
        });
        if (response.status !== 200) {
            const { message } = await response.json();
            spinner.setAttribute('hidden', 'hidden');
            showAlert(message, 'danger', false);
        } else {
            const data = await response.json();
            spinner.setAttribute('hidden', 'hidden');
            return data;
        }
    } catch (error) {
        spinner.setAttribute('hidden', 'hidden');
        showAlert(error, 'danger', false);
    }
};

window.setLicenseCost = async function(event) {
    const totalCostLicenseInput = document.querySelector('#total-cost-license');
    totalCostLicenseInput.removeAttribute('disabled');
    totalCostLicenseInput.focus();
    const { data } = await fetchLicenseCost(event.currentTarget.value);
    totalCostLicenseInput.value = data.unitPrice;
    totalCostLicenseInput.setAttribute('disabled', 'disabled');
    // document.querySelector('#amount-paid-license').focus();
};

document.querySelector('#currency-change').innerHTML = currency === 'CDF' ? '$US' : 'CDF';
document.querySelector('#invoice-search').addEventListener('submit', async (event) => {
    event.preventDefault();
    const eventTarget = event.target;
    const invoiceSpinner = eventTarget.querySelector('#invoice-spinner');
    const searchQuery = eventTarget.querySelector('#invoice-search-input').value.trim().toLowerCase();
    const savedInvoiceItems = JSON.parse(localStorage.getItem('invoiceItems') ?? '[]');

    if (searchQuery.length > 0) {
        invoiceSpinner.removeAttribute('hidden');

        const invoices = await searchInvoices(
            savedInvoiceItems,
            searchQuery,
            [
                { type: 'string', field: 'nomClient', exact: false },
                { type: 'string', field: 'typeFacture', exact: false },
                { type: 'number', field: 'id', exact: true },
                { type: 'object', field: 'dateFact', subfield: 'date', exact: false }
            ],
            true
        );

        updateInvoices(invoices, currency);
        invoiceSpinner.setAttribute('hidden', 'hidden');
    }
});
document.querySelector('#license-search').addEventListener('submit', async (event) => {
    event.preventDefault();
    const eventTarget = event.target;
    const licenseSpinner = eventTarget.querySelector('#license-spinner');
    const searchQuery = eventTarget.querySelector('#license-search-input').value.trim().toLowerCase();
    const savedLicenses = JSON.parse(localStorage.getItem('licenses') ?? '[]');

    if (searchQuery.length > 0) {
        licenseSpinner.removeAttribute('hidden');

        const licenses = await searchLicenses(
            savedLicenses,
            searchQuery,
            [
                { type: 'object', field: 'createdAt', subfield: 'date', exact: false },
                { type: 'number', field: 'numeroPv', exact: true },
                { type: 'string', field: 'numeroImmatriculation', exact: false },
                { type: 'string', field: 'nomClient', exact: false },
            ],
            true
        );

        updateLicenses(licenses, currency);
        licenseSpinner.setAttribute('hidden', 'hidden');
    }
});

document.querySelectorAll('#total, #workforce, #discount, #net, #net-ttc').forEach(total => {
    total.textContent = currency + ' 0.00';
});

document.querySelector('#caution-deposit-modal').addEventListener('shown.bs.modal', (e) => {
    const cautionDepositBody = e.currentTarget.querySelector('.modal-body');
    const spinner = document.querySelector('#spinner');
    const clientControlOption = cautionDepositBody.querySelector('#caution-client > option');
    const cautionDepositSubmit = e.currentTarget.querySelector('#caution-deposit-submit');

    const validateAndSubmit = (event) => {
        spinner.removeAttribute('hidden');

        if (validateForm(event.currentTarget.parentNode, event)) {
            fetch(`${localStorage.getItem('baseUrl')}/cautions/new`, {
                method: 'POST',
                headers: new Headers({ 'X-Requested-With': 'XMLHttpRequest' }),
                body: JSON.stringify({ client: currentInvoice.client.id, amount: (Number.parseFloat(document.querySelector('#caution-amount').value) / getRate(currency)) })
            }).then(resp => {
                if (resp.ok) {
                    resp.text().then(respBody => {
                        const responseBody = JSON.parse(respBody);
                        const data = responseBody.data;
                        spinner.setAttribute('hidden', 'hidden');
                        cautionDepositBody.querySelectorAll('.error-message').forEach(elt => {
                            elt.textContent = '';
                        });
                        cautionDepositModal.hide();
                        currentInvoice.client.totalCaution = data.totalCaution;
                        document.querySelector('#total-caution').textContent = ((currentInvoice.client.totalCaution ?? 0) * getRate(currency)).toFixed(2);

                        setTimeout(async () => {
                            const totalAmount = data.amount * getRate(currency);
                            const roundedAmount = Math.floor(totalAmount);
                            let decimals = ((totalAmount % roundedAmount).toFixed(2)) * 100;
                            const receiptCautionDepositTemplate = document.querySelector('#receipt-caution-deposit-template');
                            const fullySpelledOut = new FullySpelledOut();
                            receiptCautionDepositTemplate.removeAttribute('hidden');
                            receiptCautionDepositTemplate.innerHTML = `
                                <div class="w-100">Reçu de ${data.client}<br>
                                La somme de ${fullySpelledOut.writeInFull(roundedAmount)} ${currency === '$' ? 'dollars américains' : 'francs congolais'}${decimals > 0 ? ' et ' + fullySpelledOut.writeInFull(decimals) + ' centimes' : ''} (${roundedAmount + (decimals > 0 ? '.' + decimals : '')}${currency})<br>
                                Pour Caution
                                <div class="w-100 mt-3">Reçu par ${data.user}, ${(new Date(data.createdAt.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'long', day: 'numeric'})}</div>
                            `;
                            receiptCautionDepositTemplate.innerHTML += generateNalediSignature();

                            printJS({
                                printable: 'receipt-caution-deposit-template',
                                type: 'html',
                                header: `
                                    <div>
                                        ${await generateDocumentHeader('caution-deposit')}
                                        <br>
                                        <h3 class="w-100 text-center border" id="title-caution-deposit">REÇU CAUTION N°${data.cautionId}</h3>
                                        <br>
                                    </div>
                                `,
                                maxWidth: invoiceSettings.paperFormat.maxWidth,
                                style: `
                                        * {
                                        font-family: monospace;
                                        /* font-size: smaller !important; */
                                    }
                                
                                    #receipt-caution-deposit-template {
                                        width: 100% !important;
                                    }
                                
                                    .text-center {
                                        text-align: center;
                                    }
                                
                                    .border {
                                        border: 1px solid #000;
                                    }
                                
                                    .border-bottom-dashed {
                                        border-bottom: 1px solid dashed;
                                    }
                                
                                    .mt-3 {
                                        margin-top: 1.8em;
                                    }
                                
                                    .w-100 {
                                        width: 100% !important;
                                    }
                                
                                    .w-90 {
                                        width: 90% !important;
                                    }
                                
                                    .w-75 {
                                        width: 75% !important;
                                    }
                                
                                    .w-70 {
                                        width: 70% !important;
                                    }
                                
                                    .w-60 {
                                        width: 60% !important;
                                    }
                                
                                    .w-50 {
                                        width: 50% !important;
                                    }
                                
                                    .w-40 {
                                        width: 40 !important;
                                    }
                                
                                    .w-30 {
                                        width: 30% !important;
                                    }
                                
                                    .w-25 {
                                        width: 25% !important;
                                    }
                                
                                    h3 {
                                        font-weight: bolder !important;
                                    }
                                
                                    #company-caution-deposit {
                                        /* margin-top: -25px !important; */
                                        margin-bottom: -5px !important;
                                    }
                                
                                    #title-caution-deposit {
                                        margin-top: 0px !important;
                                        margin-bottom: 0px !important;
                                    }
                                
                                    #print-naledi-signature {
                                        text-align: center;
                                        width: 100% !important;
                                        border-top: 1px dashed #000;
                                        margin-top: 10px;
                                        font-size: smaller;
                                    }
                                `
                            });
                            receiptCautionDepositTemplate.setAttribute('hidden', 'hidden');
                        }, 1000);
                        showAlert(responseBody.message, 'success', false);
                    });
                } else {
                    resp.text().then(respBody => {
                        const { message, errors } = JSON.parse(respBody);
                        spinner.setAttribute('hidden', 'hidden');

                        for (const propertyPath in errors) {
                            const error = errors[propertyPath];
                            const errorElt = cautionDepositBody.querySelector('#caution-' + propertyPath + '-control + .error-message');
                            errorElt.style.fontSize = 'smaller';
                            error.forEach(err => {
                                errorElt.textContent += err.message + ' ';
                            });
                        }

                        showAlert(message, 'danger', false);
                    });
                }
                cautionDepositSubmit.removeEventListener('click', validateAndSubmit);
            }).catch(() => {
                spinner.setAttribute('hidden', 'hidden');
                showAlert('Echec de l\'opération ! Vérifiez votre connexion !', 'danger', false);
            });
        } else {
            spinner.setAttribute('hidden', 'hidden');
            showAlert('Le formulaire contient des erreurs.', 'danger', false);
        }
    };

    cautionDepositBody.querySelector('#caution-amount').addEventListener('input', (event) => {
        const errorElt = document.querySelector('#caution-amount-control + .error-message');
        errorElt.style.fontSize = 'smaller';
        errorElt.textContent = event.currentTarget.validity.valid ? '' : 'Veuillez entrer un montant valide (positif et maximum 5 chiffres après la virgule).';
    });

    clientControlOption.value = currentInvoice.client.id;
    clientControlOption.textContent = currentInvoice.client.nomClient;
    cautionDepositSubmit.addEventListener('click', validateAndSubmit);
});

window.addEventListener('DOMContentLoaded', async () => {
    const jsonSessionInvoice = sessionStorage.getItem('invoice');
    // const response = await fetch(`${localStorage.getItem('baseUrl')}/company/logo`);
    // companyLogo = await response.body;
    // console.log(companyLogo);
    // const response = await fetch(`${localStorage.getItem('baseUrl')}/company/logo`);

    // if (response.status !== 200) {
    //     showAlert('Unable to download file.', 'danger', false);
    // }

    // const blob = await response.blob();

    // // Create a download link
    // const downloadLink = document.createElement('img');
    // downloadLink.src = URL.createObjectURL(blob);
    // companyLogo = downloadLink;
    // console.log(downloadLink);
    // await downloadFile(`${localStorage.getItem('baseUrl')}/company/logo`, 'company-logo.jpg');

    if (null !== jsonSessionInvoice) {
        const sessionInvoice = JSON.parse(jsonSessionInvoice);
        if (null !== sessionInvoice.client) {
            client = clients.find(c => c.id === sessionInvoice.client);
        }

        licenseId = sessionInvoice.licenseId ?? 0;

        currentInvoice.id = sessionStorage.getItem('invoiceId');
        currentInvoice.type = sessionInvoice.saleType;
        currentInvoice.date = sessionInvoice.date;
        currentInvoice.total = sessionInvoice.total;
        currentInvoice.discount = sessionInvoice.discount;
        currentInvoice.workforce = sessionInvoice.workforce;
        currentInvoice.workforcePercent = sessionInvoice.workforcePercent;
        currentInvoice.paymentMode = sessionInvoice.paymentMode;
        currentInvoice.articles = sessionInvoice.details?.articles;
        currentInvoice.services = sessionInvoice.details?.services;
        sessionInvoice.id = currentInvoice.id;

        if (currentInvoice.type !== 'hold') {
            await printInvoice('FACTURE', currentInvoice, { itemsContainer: 'table' });
            currentInvoice = { id: null, client: { id: null }, articles: {}, services: {}, total: 0, workforce: 0, discount: 0 };
        }

        currentInvoice.total = 0;
        sessionStorage.removeItem('invoice');
        // sessionStorage.removeItem('invoicePrint');
        // sessionStorage.removeItem('invoiceId');
    }
});

new mdb.Autocomplete(clientAutocomplete, {
    filter: clientsFilter,
    displayValue: value => {
        currentInvoice.client = value;
        currentInvoice.client.totalFactures = isNaN(currentInvoice.client.totalFactures) || 'undefined' === currentInvoice.client.totalFactures || null === currentInvoice.client.totalFactures ? 0 : ('string' === typeof currentInvoice.client.totalFactures ? Number.parseInt(currentInvoice.client.totalFactures, 10) : currentInvoice.client.totalFactures);
        currentInvoice.client.totalBonus = isNaN(currentInvoice.client.totalBonus) || 'undefined' === currentInvoice.client.totalBonus || null === currentInvoice.client.totalBonus ? 0 : ('string' === typeof currentInvoice.client.totalBonus ? Number.parseFloat(currentInvoice.client.totalBonus) : currentInvoice.client.totalBonus);
        currentInvoice.client.totalCaution = isNaN(currentInvoice.client.totalCaution) || 'undefined' === currentInvoice.client.totalCaution || null === currentInvoice.client.totalCaution ? 0 : ('string' === typeof currentInvoice.client.totalCaution ? Number.parseFloat(currentInvoice.client.totalCaution) : currentInvoice.client.totalCaution);
        document.querySelector('#total-factures').textContent = currentInvoice.client.totalFactures;
        document.querySelector('#total-bonus').textContent = ((currentInvoice.client.totalBonus ?? 0) * getRate(currency)).toFixed(2);
        document.querySelector('#total-caution').textContent = ((currentInvoice.client.totalCaution ?? 0) * getRate(currency)).toFixed(2);
        return value.nomClient;
    }
});

new mdb.Autocomplete(serviceAutocomplete, {
    filter: servicesFilter,
    threshold: 2,
    displayValue: value => {
        currentService = value;
        return value.name;
    },
    noResults: ''
});

immatriculationAutocompletes.forEach(input => {
    input.addEventListener('keyup', (e) => {
        const searchQuery = e.currentTarget.value;
        const prefix = input.id === 'numeroImmatriculation' ? 'immatriculation' : 'vehicle-' + input.id.split('-')[1];
        const dropdownMenu = document.querySelector(`#${prefix}-dropdown`);
    
        if (searchQuery.length > 1) {
            const spinner = document.querySelector(`#${prefix}-spinner`);
            spinner.removeAttribute('hidden');
            vehiclesFilter(searchQuery).then(data => {
                spinner.setAttribute('hidden', 'hidden');
                dropdownMenu.style.display = 'block';
                if (data.length > 0) {
                    let listItems = '';
                    data.forEach(item => {
                        const vehicleDetails = [item.genre, item.marque, item.typeOuModele];
                        listItems += `<li class="dropdown-item" data-id="${item.id}" onclick="selectVehicleItem(event)">${item.numeroImmatriculation}${prefix !== 'immatriculation' ? ' (' + vehicleDetails.join(' - ') + ')' : ''}</li>`;
                    });
                    dropdownMenu.innerHTML = listItems;
                } else {
                    dropdownMenu.innerHTML = '';
                }
            });
        } else {
            dropdownMenu.style.display = 'none';
        }
    });
});

document.querySelector('#client').addEventListener('keyup', (e) => {
    const searchQuery = e.currentTarget.value;
    const removeClientIdAttribute = () => {
        document.querySelector('#client').removeAttribute('data-client-id');
    };
    removeClientIdAttribute();

    if (searchQuery.length > 1) {
        const spinner = document.querySelector('#client-spinner');
        spinner.removeAttribute('hidden');
        clientsFilter(searchQuery).then(data => {
            spinner.setAttribute('hidden', 'hidden');
            clientDropdownMenu.style.display = 'block';
            if (data.length > 0) {
                let listItems = '';
                data.forEach(item => {
                    listItems += `<li class="dropdown-item" onclick="selectClientItem(event)">${item.nomClient}</li>`;
                });
                clientDropdownMenu.innerHTML = listItems;
            } else {
                removeClientIdAttribute();
                clientDropdownMenu.innerHTML = '<li class="dropdown-item">No results found</li>';
            }
        });
    } else {
        clientDropdownMenu.style.display = 'none';
    }
});

document.querySelector('#usageVehicule').addEventListener('keyup', (e) => {
    const searchQuery = e.currentTarget.value;

    if (searchQuery.length > 1) {
        const spinner = document.querySelector('#usage-vehicule-spinner');
        spinner.removeAttribute('hidden');
        usagesVehiculeFilter(searchQuery).then(data => {
            spinner.setAttribute('hidden', 'hidden');
            usageVehiculeDropdownMenu.style.display = 'block';
            if (data.length > 0) {
                let listItems = '';
                data.forEach(item => {
                    listItems += `<li class="dropdown-item" onclick="selectUsageVehiculeItem(event)">${item}</li>`;
                });
                usageVehiculeDropdownMenu.innerHTML = listItems;
            } else {
                usageVehiculeDropdownMenu.innerHTML = '<li class="dropdown-item">No results found</li>';
            }
        });
    } else {
        usageVehiculeDropdownMenu.style.display = 'none';
    }
});

[clientAutocomplete, serviceAutocomplete].forEach((elt, idx) => {
    elt.addEventListener('itemSelect.mdb.autocomplete', (event) => {
        if (idx === 0) {
            setTimeout(() => {
                const isDiscountApplicable = currentInvoice.client.id !== null && currentInvoice.client.discountApplicable;
                // let discountAmount = 0;
                const workforceAmount = 'number' === typeof workforcePercent && workforcePercent > 0 ? workforcePercent * currentInvoice.total : 0;
                const discountElt = document.querySelector('#discount');
                const workforceElt = document.querySelector('#workforce');
                const totalNet = Math.abs(currentInvoice.total + workforceAmount - currentInvoice.discount);
                const vatAmount = currentInvoice.vatAmount;

                if (isDiscountApplicable && currentInvoice.discount === 0) {
                    applyDiscount(currentInvoice, discountables);
                } else if (!isDiscountApplicable && currentInvoice.discount > 0) {
                    removeDiscount(currentInvoice);
                }

                document.querySelector('#customerName').textContent = currentInvoice.client.nomClient;
                enableCustomerDetailsButtons('customerDetails', 'customerCaution');
                if (null !== discountElt) {
                    discountElt.textContent = currency + ' ' + (getRate(currency) * currentInvoice.discount).toFixed(2);
                }
                if (null !== workforceElt) {
                    workforceElt.textContent = currency + ' ' + (getRate(currency) * workforceAmount).toFixed(2);
                }
                document.querySelector('#net').textContent = currency + ' ' + (getRate(currency) * totalNet).toFixed(2);
                if (ttcAmountElt !== null) {
                    ttcAmountElt.textContent = currency + ' ' + ((totalNet + vatAmount) * getRate(currency)).toFixed(2);
                }
            }, 10);
        } else {
            setTimeout(() => {
                currentInvoice = addToCart(currentService.serviceId, 1, currentInvoice);
            }, 10);
        }

        setTimeout(() => {
            const input = elt.querySelector('input');
            emptyInput(input);
            input.blur();
        }, 1000);
    });
});

newControleModalElt.addEventListener('show.bs.modal', () => {
    document.querySelectorAll('#new-ct-form input, #new-ct-form select').forEach((field) => {
        field.value = null;
    });
});

displayGrid(grid, gridContent.content);
