import { setServerIp } from "./functions";

window.setIp = setServerIp;

document.querySelector('form').addEventListener('submit', (event) => {
    const currentTarget = event.currentTarget;
    const username = currentTarget.querySelector('#inputUsername').value;
    const password = currentTarget.querySelector('#inputPassword').value;
    const spinner = document.querySelector('#spinner');
    event.preventDefault();
    spinner.removeAttribute('hidden');

    fetch(`${localStorage.getItem('baseUrl')}/api/login_check`, {
        method: 'POST',
        headers: new Headers({ 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' }),
        body: JSON.stringify({ username, password })
    }).then(response => {
        if (response.ok) {
            response.text().then(resp => {
                const authResult = JSON.parse(resp);
                // const expiresAt = moment().add(1, 'years');

                localStorage.setItem('token', authResult.token);
                localStorage.setItem('userId', authResult.user.id);
                localStorage.setItem('username', authResult.user.username);
                localStorage.setItem('roles', authResult.user.roles);
                // localStorage.setItem("expiresAt", JSON.stringify(expiresAt.valueOf()));
                // localStorage.setItem("expiresAt", JSON.stringify(expiresAt.valueOf()));
                currentTarget.submit();
            });
        } else {
            response.text().then(resp => {
                let msg;

                switch (response.status) {
                    case 401:
                        const { code, message } = JSON.parse(resp);
                        msg = code === 401 && message === 'Invalid credentials.' ? 'Nom d\'utilisateur ou mot de passe incorrect' : message;
                        break;
                    case 500:
                        const m = 'Veuillez contacter l\'administrateur du système.';
                        msg = resp.indexOf('SQLSTATE') !== -1 ? `Base de données inaccessible! ${m}` : `Erreur! ${m}`;
                        break;
                    default:
                        msg = 'Une erreur s\'est produite!';
                        break;
                }

                spinner.setAttribute('hidden', 'hidden');
                showAlert(msg, 'danger', false);
            });
        }
    }).catch(() => {
        spinner.setAttribute('hidden', 'hidden');
        showAlert('Vérifiez votre connexion. Si le problème persiste, veuillez contacter l\'administrateur du système.', 'danger', false);
    });
});
