const invoicesDatatable = document.getElementById('invoices-datatable');
const invoices = JSON.parse(invoicesDatatable.dataset.factures);

const invoicesTableInstance = new mdb.Datatable(invoicesDatatable, {
    columns: [
        { label: 'Date facture', field: 'dateFact' },
        { label: 'N° Facture', field: 'id' },
        { label: 'Client', field: 'nomClient' },
        { label: 'Montant', field: 'total' }
    ],
    rows: invoices.map(row => {
        return {
            ...row,
            dateFact: `${(new Date(row.dateFact.date)).toLocaleDateString('fr-FR', {year: 'numeric', month: 'short', day: 'numeric'})}`,
            total: `${row.total.toFixed(2)} $`
        }
    })
}, { hover: true });

document.getElementById('datatable-search-input').addEventListener('input', (e) => {
    invoicesTableInstance.search(e.target.value);
});
