window.setMainCurrency = async (event) => {
    const mainCurrencySwitch = event.currentTarget;
    const mainCurrencyId = mainCurrencySwitch.dataset.currencyId;

    if (mainCurrencySwitch.checked) {
        const spinner = document.querySelector('#spinner');
        spinner.removeAttribute('hidden');
        const headers = new Headers({ 'Content-Type': 'application/json', 'X-Requested-With': 'XMLHttpRequest' });
        await fetch(`${localStorage.getItem('baseUrl')}/currencies/${mainCurrencyId}`, {
            method: 'POST',
            headers,
            body: JSON.stringify({ main: 'on' })
        });
        document.querySelectorAll('.form-check-input').forEach((switchInput) => {
            if (switchInput.dataset.currencyId != mainCurrencyId && switchInput.checked) {
                switchInput.click();
            }
        });
        spinner.setAttribute('hidden', 'hidden');
    }
};
