const cautionsDatatable = document.getElementById('cautions-datatable');
const cautions = JSON.parse(cautionsDatatable.dataset.cautions);
const currency = cautionsDatatable.dataset.currency;

const cautionsTableInstance = new mdb.Datatable(cautionsDatatable, {
    columns: [
        { label: 'Client', field: 'nomClient' },
        { label: 'Date de depot', field: 'date' },
        { label: `Montant (en ${currency})`, field: 'amount' },
        { label: `Utilisé (en ${currency})`, field: 'amountUsed' }
    ],
    rows: cautions.map(row => {
        return {
            ...row,
            date: (new Date(row.createdAt.date)).toLocaleDateString('fr-FR', {day: 'numeric', month: 'short', year: 'numeric'})
        }
    },
    { hover: true })
},);

// const setActions = (e) => {
//     e.currentTarget.querySelectorAll('tbody > tr').forEach((rowElt, idx) => {
//         rowElt.style.cursor = 'pointer';
//         rowElt.querySelectorAll('td:last-child > a').forEach(btn => {
//             const path = btn.dataset.delete, entityName = btn.parentNode.parentNode.querySelector('td:nth-of-type(1)').textContent.trim();
//             btn.addEventListener('click', () => {
//                 if (confirm(`Voulez-vous vraiment supprimer ${entityName} ?`)) {
//                     fetch(`${localStorage.getItem('baseUrl')}${path}/delete`, {
//                         method: 'DELETE'
//                     })
//                     .then(resp => {
//                         if (resp.ok) {
//                             resp.text().then(data => {
//                                 showAlert(JSON.parse(data), 'success');
//                             });
//                         }
//                     });
//                 }
//             });
//         });
//     });
// };

// cautionsDatatable.addEventListener('render.mdb.datatable', setActions);

document.getElementById('datatable-search-input').addEventListener('input', (e) => {
    cautionsTableInstance.search(e.target.value);
});
